/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.util;

import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.ObjectReaderImplDate;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.util.JDKUtils;
import java.nio.charset.StandardCharsets;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.TimeZone;

public class DateUtils {
    public static Date parseDate(String str) {
        long millis;
        if (str == null) {
            return null;
        }
        int strlen = str.length();
        if (strlen == 0 || "null".equals(str)) {
            return null;
        }
        if (strlen > 2) {
            char first = str.charAt(0);
            char last = str.charAt(strlen - 1);
            if (first == '\"' && last == '\"') {
                try (JSONReader jsonReader = JSONReader.of(str);){
                    Date date = (Date)ObjectReaderImplDate.INSTANCE.readObject(jsonReader, null, null, 0L);
                    return date;
                }
            }
        }
        if (strlen == 19) {
            millis = DateUtils.toMillis19(str, 0, IOUtils.DEFAULT_ZONE_ID);
        } else if (strlen > 19) {
            ZonedDateTime zdt = DateUtils.parseZonedDateTime(str, 0, strlen, IOUtils.DEFAULT_ZONE_ID);
            millis = zdt.toInstant().toEpochMilli();
        } else if (IOUtils.isNumber(str)) {
            millis = Long.parseLong(str);
            if (strlen == 8 && millis >= 19700101L && millis <= 21000101L) {
                int year = (int)millis / 10000;
                int month = (int)millis % 10000 / 100;
                int dom = (int)millis % 100;
                if (month >= 1 && month <= 12) {
                    int max = 31;
                    switch (month) {
                        case 2: {
                            boolean leapYear = (year & 3) == 0 && (year % 100 != 0 || year % 400 == 0);
                            max = leapYear ? 29 : 28;
                            break;
                        }
                        case 4: 
                        case 6: 
                        case 9: 
                        case 11: {
                            max = 30;
                        }
                    }
                    if (dom <= max) {
                        LocalDateTime ldt = LocalDateTime.of(year, month, dom, 0, 0, 0);
                        ZonedDateTime zdt = ZonedDateTime.ofLocal(ldt, IOUtils.DEFAULT_ZONE_ID, null);
                        long seconds = zdt.toEpochSecond();
                        millis = seconds * 1000L;
                    }
                }
            }
        } else {
            char last = str.charAt(strlen - 1);
            ZoneId zoneId = last == 'Z' ? ZoneOffset.UTC : IOUtils.DEFAULT_ZONE_ID;
            LocalDateTime ldt = DateUtils.parseLocalDateTime(str, 0, strlen);
            if (ldt == null && "0000-00-00".equals(str)) {
                ldt = LocalDateTime.of(1970, 1, 1, 0, 0, 0);
            }
            ZonedDateTime zdt = ZonedDateTime.ofLocal(ldt, zoneId, null);
            long seconds = zdt.toEpochSecond();
            int nanos = ldt.getNano();
            millis = seconds < 0L && nanos > 0 ? (seconds + 1L) * 1000L + (long)(nanos / 1000000) - 1000L : seconds * 1000L + (long)(nanos / 1000000);
        }
        return new Date(millis);
    }

    public static LocalDateTime parseLocalDateTime(String str) {
        if (str == null) {
            return null;
        }
        return DateUtils.parseLocalDateTime(str, 0, str.length());
    }

    public static LocalDateTime parseLocalDateTime(String str, int off, int len) {
        if (str == null || len == 0) {
            return null;
        }
        switch (len) {
            case 4: {
                if (str.regionMatches(0, "null", off, len)) {
                    return null;
                }
                String input = str.substring(off, len);
                throw new DateTimeParseException("illegal input " + input, input, 0);
            }
            case 8: {
                LocalDate localDate = DateUtils.parseLocalDate8(str, off);
                if (localDate == null) {
                    return null;
                }
                return LocalDateTime.of(localDate, LocalTime.MIN);
            }
            case 9: {
                LocalDate localDate = DateUtils.parseLocalDate9(str, off);
                if (localDate == null) {
                    return null;
                }
                return LocalDateTime.of(localDate, LocalTime.MIN);
            }
            case 10: {
                LocalDate localDate = DateUtils.parseLocalDate10(str, off);
                if (localDate == null) {
                    return null;
                }
                return LocalDateTime.of(localDate, LocalTime.MIN);
            }
            case 11: {
                LocalDate localDate = DateUtils.parseLocalDate11(str, off);
                return LocalDateTime.of(localDate, LocalTime.MIN);
            }
            case 12: {
                return DateUtils.parseLocalDateTime12(str, off);
            }
            case 14: {
                return DateUtils.parseLocalDateTime14(str, off);
            }
            case 16: {
                return DateUtils.parseLocalDateTime16(str, off);
            }
            case 17: {
                return DateUtils.parseLocalDateTime17(str, off);
            }
            case 18: {
                return DateUtils.parseLocalDateTime18(str, off);
            }
            case 19: {
                return DateUtils.parseLocalDateTime19(str, off);
            }
        }
        return DateUtils.parseLocalDateTimeX(str, off, len);
    }

    public static LocalDate parseLocalDate(String str) {
        if (str == null) {
            return null;
        }
        return DateUtils.parseLocalDate(str, 0, str.length());
    }

    public static LocalDate parseLocalDate(String str, int off, int len) {
        if (str == null || len == 0) {
            return null;
        }
        if (off + len > str.length()) {
            String input = str.substring(off);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        switch (len) {
            case 8: {
                return DateUtils.parseLocalDate8(str, off);
            }
            case 9: {
                return DateUtils.parseLocalDate9(str, off);
            }
            case 10: {
                return DateUtils.parseLocalDate10(str, off);
            }
            case 11: {
                return DateUtils.parseLocalDate11(str, off);
            }
        }
        String input = str.substring(off, off + len);
        if ("null".equals(input)) {
            return null;
        }
        throw new DateTimeParseException("illegal input " + input, input, 0);
    }

    public static LocalDate parseLocalDate8(String str, int off) {
        char d1;
        int d0;
        char m1;
        int m0;
        char y3;
        char y2;
        char y1;
        char y0;
        if (off + 8 > str.length()) {
            throw new DateTimeParseException("illegal input", str.substring(off), 0);
        }
        char c0 = str.charAt(off + 0);
        char c1 = str.charAt(off + 1);
        char c2 = str.charAt(off + 2);
        char c3 = str.charAt(off + 3);
        int c4 = str.charAt(off + 4);
        char c5 = str.charAt(off + 5);
        int c6 = str.charAt(off + 6);
        char c7 = str.charAt(off + 7);
        if (c4 == 45 && c6 == 45) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = 48;
            m1 = c5;
            d0 = 48;
            d1 = c7;
        } else {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c4;
            m1 = c5;
            d0 = c6;
            d1 = c7;
        }
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            String input = str.substring(off, off + 8);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < 48 || m0 > 57 || m1 < '0' || m1 > '9') {
            String input = str.substring(off, off + 8);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < 48 || d0 > 57 || d1 < '0' || d1 > '9') {
            String input = str.substring(off, off + 8);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (year == 0 && month == 0 && dom == 0) {
            return null;
        }
        return LocalDate.of(year, month, dom);
    }

    public static LocalDate parseLocalDate9(String str, int off) {
        int d1;
        int d0;
        int m1;
        int m0;
        int y3;
        char y2;
        int y1;
        int y0;
        if (off + 9 > str.length()) {
            throw new DateTimeParseException("illegal input", str.substring(off), 0);
        }
        int c0 = str.charAt(off + 0);
        int c1 = str.charAt(off + 1);
        char c2 = str.charAt(off + 2);
        int c3 = str.charAt(off + 3);
        char c4 = str.charAt(off + 4);
        int c5 = str.charAt(off + 5);
        int c6 = str.charAt(off + 6);
        char c7 = str.charAt(off + 7);
        int c8 = str.charAt(off + 8);
        if (c4 == '-' && c7 == '-') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = 48;
            d1 = c8;
        } else if (c4 == '-' && c6 == 45) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = 48;
            m1 = c5;
            d0 = c7;
            d1 = c8;
        } else if (c4 == '/' && c7 == '/') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = 48;
            d1 = c8;
        } else if (c4 == '/' && c6 == 47) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = 48;
            m1 = c5;
            d0 = c7;
            d1 = c8;
        } else if (c1 == 46 && c4 == '.') {
            d0 = 48;
            d1 = c0;
            m0 = c2;
            m1 = c3;
            y0 = c5;
            y1 = c6;
            y2 = c7;
            y3 = c8;
        } else if (c2 == '.' && c4 == '.') {
            d0 = c0;
            d1 = c1;
            m0 = 48;
            m1 = c3;
            y0 = c5;
            y1 = c6;
            y2 = c7;
            y3 = c8;
        } else if (c1 == 45 && c4 == '-') {
            d0 = 48;
            d1 = c0;
            m0 = c2;
            m1 = c3;
            y0 = c5;
            y1 = c6;
            y2 = c7;
            y3 = c8;
        } else if (c2 == '-' && c4 == '-') {
            d0 = c0;
            d1 = c1;
            m0 = 48;
            m1 = c3;
            y0 = c5;
            y1 = c6;
            y2 = c7;
            y3 = c8;
        } else if (c4 == '\u5e74' && c6 == 26376 && c8 == 26085) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = 48;
            m1 = c5;
            d0 = 48;
            d1 = c7;
        } else if (c4 == '\ub144' && c6 == 50900 && c8 == 51068) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = 48;
            m1 = c5;
            d0 = 48;
            d1 = c7;
        } else {
            String input = str.substring(off, off + 9);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        if (y0 < 48 || y0 > 57 || y1 < 48 || y1 > 57 || y2 < '0' || y2 > '9' || y3 < 48 || y3 > 57) {
            String input = str.substring(off, off + 9);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < 48 || m0 > 57 || m1 < 48 || m1 > 57) {
            String input = str.substring(off, off + 9);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < 48 || d0 > 57 || d1 < 48 || d1 > 57) {
            String input = str.substring(off, off + 9);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (year == 0 && month == 0 && dom == 0) {
            return null;
        }
        return LocalDate.of(year, month, dom);
    }

    public static LocalDate parseLocalDate10(String str, int off) {
        int d1;
        int d0;
        int m1;
        int m0;
        int y3;
        int y2;
        int y1;
        int y0;
        if (off + 10 > str.length()) {
            throw new DateTimeParseException("illegal input", str.substring(off), 0);
        }
        int c0 = str.charAt(off + 0);
        int c1 = str.charAt(off + 1);
        int c2 = str.charAt(off + 2);
        int c3 = str.charAt(off + 3);
        int c4 = str.charAt(off + 4);
        int c5 = str.charAt(off + 5);
        int c6 = str.charAt(off + 6);
        int c7 = str.charAt(off + 7);
        int c8 = str.charAt(off + 8);
        int c9 = str.charAt(off + 9);
        if (c4 == 45 && c7 == 45) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
        } else if (c4 == 47 && c7 == 47) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
        } else if (c2 == 46 && c5 == 46) {
            d0 = c0;
            d1 = c1;
            m0 = c3;
            m1 = c4;
            y0 = c6;
            y1 = c7;
            y2 = c8;
            y3 = c9;
        } else if (c2 == 45 && c5 == 45) {
            d0 = c0;
            d1 = c1;
            m0 = c3;
            m1 = c4;
            y0 = c6;
            y1 = c7;
            y2 = c8;
            y3 = c9;
        } else if (c4 == 24180 && c6 == 26376 && c9 == 26085) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = 48;
            m1 = c5;
            d0 = c7;
            d1 = c8;
        } else if (c4 == 45380 && c6 == 50900 && c9 == 51068) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = 48;
            m1 = c5;
            d0 = c7;
            d1 = c8;
        } else if (c4 == 24180 && c7 == 26376 && c9 == 26085) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = 48;
            d1 = c8;
        } else if (c4 == 45380 && c7 == 50900 && c9 == 51068) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = 48;
            d1 = c8;
        } else {
            throw new DateTimeParseException("illegal input", str.substring(off, off + 10), 0);
        }
        if (y0 < 48 || y0 > 57 || y1 < 48 || y1 > 57 || y2 < 48 || y2 > 57 || y3 < 48 || y3 > 57) {
            throw new DateTimeParseException("illegal input", str.substring(off, off + 10), 0);
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < 48 || m0 > 57 || m1 < 48 || m1 > 57) {
            throw new DateTimeParseException("illegal input", str.substring(off, off + 10), 0);
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < 48 || d0 > 57 || d1 < 48 || d1 > 57) {
            throw new DateTimeParseException("illegal input", str.substring(off, off + 10), 0);
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (year == 0 && month == 0 && dom == 0) {
            return null;
        }
        return LocalDate.of(year, month, dom);
    }

    public static LocalDate parseLocalDate11(String str, int off) {
        char d1;
        char d0;
        char m1;
        char m0;
        char y3;
        char y2;
        char y1;
        char y0;
        if (off + 11 > str.length()) {
            throw new DateTimeParseException("illegal input", str.substring(off), 0);
        }
        char c0 = str.charAt(off + 0);
        char c1 = str.charAt(off + 1);
        char c2 = str.charAt(off + 2);
        char c3 = str.charAt(off + 3);
        char c4 = str.charAt(off + 4);
        char c5 = str.charAt(off + 5);
        char c6 = str.charAt(off + 6);
        char c7 = str.charAt(off + 7);
        char c8 = str.charAt(off + 8);
        char c9 = str.charAt(off + 9);
        char c10 = str.charAt(off + 10);
        if (c4 == '\u5e74' && c7 == '\u6708' && c10 == '\u65e5') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
        } else if (c4 == '\ub144' && c7 == '\uc6d4' && c10 == '\uc77c') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
        } else {
            String input = str.substring(off, off + 11);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            String input = str.substring(off, off + 11);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < '0' || m0 > '9' || m1 < '0' || m1 > '9') {
            String input = str.substring(off, off + 11);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < '0' || d0 > '9' || d1 < '0' || d1 > '9') {
            String input = str.substring(off, off + 11);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (year == 0 && month == 0 && dom == 0) {
            return null;
        }
        return LocalDate.of(year, month, dom);
    }

    public static LocalDateTime parseLocalDateTime12(String str, int off) {
        if (off + 12 > str.length()) {
            String input = str.substring(off);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        char y0 = str.charAt(off + 0);
        char y1 = str.charAt(off + 1);
        char y2 = str.charAt(off + 2);
        char y3 = str.charAt(off + 3);
        char m0 = str.charAt(off + 4);
        char m1 = str.charAt(off + 5);
        char d0 = str.charAt(off + 6);
        char d1 = str.charAt(off + 7);
        char h0 = str.charAt(off + 8);
        char h1 = str.charAt(off + 9);
        char i0 = str.charAt(off + 10);
        char i1 = str.charAt(off + 11);
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            String input = str.substring(off, off + 12);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < '0' || m0 > '9' || m1 < '0' || m1 > '9') {
            String input = str.substring(off, off + 12);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < '0' || d0 > '9' || d1 < '0' || d1 > '9') {
            String input = str.substring(off, off + 12);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (h0 < '0' || h0 > '9' || h1 < '0' || h1 > '9') {
            String input = str.substring(off, off + 12);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < '0' || i0 > '9' || i1 < '0' || i1 > '9') {
            String input = str.substring(off, off + 12);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (year == 0 && month == 0 && dom == 0 && hour == 0 && minute == 0) {
            return null;
        }
        return LocalDateTime.of(year, month, dom, hour, minute, 0);
    }

    public static LocalDateTime parseLocalDateTime14(String str, int off) {
        if (off + 14 > str.length()) {
            String input = str.substring(off);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        char y0 = str.charAt(off + 0);
        char y1 = str.charAt(off + 1);
        char y2 = str.charAt(off + 2);
        char y3 = str.charAt(off + 3);
        char m0 = str.charAt(off + 4);
        char m1 = str.charAt(off + 5);
        char d0 = str.charAt(off + 6);
        char d1 = str.charAt(off + 7);
        char h0 = str.charAt(off + 8);
        char h1 = str.charAt(off + 9);
        char i0 = str.charAt(off + 10);
        char i1 = str.charAt(off + 11);
        char s0 = str.charAt(off + 12);
        char s1 = str.charAt(off + 13);
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            String input = str.substring(off, off + 14);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < '0' || m0 > '9' || m1 < '0' || m1 > '9') {
            String input = str.substring(off, off + 14);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < '0' || d0 > '9' || d1 < '0' || d1 > '9') {
            String input = str.substring(off, off + 14);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (h0 < '0' || h0 > '9' || h1 < '0' || h1 > '9') {
            String input = str.substring(off, off + 14);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < '0' || i0 > '9' || i1 < '0' || i1 > '9') {
            String input = str.substring(off, off + 14);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < '0' || s0 > '9' || s1 < '0' || s1 > '9') {
            String input = str.substring(off, off + 14);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        return LocalDateTime.of(year, month, dom, hour, minute, second);
    }

    public static LocalDateTime parseLocalDateTime16(String str, int off) {
        int i1;
        int i0;
        int h1;
        int h0;
        int d1;
        char d0;
        char m1;
        char m0;
        char y3;
        char y2;
        char y1;
        char y0;
        if (off + 16 > str.length()) {
            String input = str.substring(off);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        char c0 = str.charAt(off + 0);
        char c1 = str.charAt(off + 1);
        char c2 = str.charAt(off + 2);
        char c3 = str.charAt(off + 3);
        char c4 = str.charAt(off + 4);
        char c5 = str.charAt(off + 5);
        char c6 = str.charAt(off + 6);
        int c7 = str.charAt(off + 7);
        char c8 = str.charAt(off + 8);
        int c9 = str.charAt(off + 9);
        int c10 = str.charAt(off + 10);
        int c11 = str.charAt(off + 11);
        int c12 = str.charAt(off + 12);
        char c13 = str.charAt(off + 13);
        int c14 = str.charAt(off + 14);
        int c15 = str.charAt(off + 15);
        int s0 = 48;
        int s1 = 48;
        if (c4 == '-' && c7 == 45 && (c10 == 84 || c10 == 32) && c13 == ':') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
        } else if (c8 == 'T' && c15 == 90) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c4;
            m1 = c5;
            d0 = c6;
            d1 = c7;
            h0 = c9;
            h1 = c10;
            i0 = c11;
            i1 = c12;
            s0 = c13;
            s1 = c14;
        } else if (c4 == '-' && c7 == 45 && (c10 == 84 || c10 == 32) && c12 == 58 && c14 == 58) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = 48;
            h1 = c11;
            i0 = 48;
            i1 = c13;
            s0 = 48;
            s1 = c15;
        } else {
            String input = str.substring(off, off + 16);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            String input = str.substring(off, off + 16);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < '0' || m0 > '9' || m1 < '0' || m1 > '9') {
            String input = str.substring(off, off + 16);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < '0' || d0 > '9' || d1 < 48 || d1 > 57) {
            String input = str.substring(off, off + 16);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (h0 < 48 || h0 > 57 || h1 < 48 || h1 > 57) {
            String input = str.substring(off, off + 16);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < 48 || i0 > 57 || i1 < 48 || i1 > 57) {
            String input = str.substring(off, off + 16);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < 48 || s0 > 57 || s1 < 48 || s1 > 57) {
            String input = str.substring(off, off + 16);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        return LocalDateTime.of(year, month, dom, hour, minute, second);
    }

    public static LocalDateTime parseLocalDateTime17(String str, int off) {
        int s1;
        int s0;
        char i1;
        char i0;
        char h1;
        char h0;
        char d1;
        int d0;
        int m1;
        int m0;
        char y3;
        char y2;
        char y1;
        char y0;
        if (off + 17 > str.length()) {
            String input = str.substring(off);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        char c0 = str.charAt(off + 0);
        char c1 = str.charAt(off + 1);
        char c2 = str.charAt(off + 2);
        char c3 = str.charAt(off + 3);
        char c4 = str.charAt(off + 4);
        int c5 = str.charAt(off + 5);
        int c6 = str.charAt(off + 6);
        char c7 = str.charAt(off + 7);
        int c8 = str.charAt(off + 8);
        char c9 = str.charAt(off + 9);
        char c10 = str.charAt(off + 10);
        char c11 = str.charAt(off + 11);
        char c12 = str.charAt(off + 12);
        char c13 = str.charAt(off + 13);
        char c14 = str.charAt(off + 14);
        char c15 = str.charAt(off + 15);
        char c16 = str.charAt(off + 16);
        if (c4 == '-' && c7 == '-' && (c10 == 'T' || c10 == ' ') && c13 == ':' && c16 == 'Z') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = 48;
            s1 = 48;
        } else if (c4 == '-' && c6 == 45 && (c8 == 32 || c8 == 84) && c11 == ':' && c14 == ':') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = 48;
            m1 = c5;
            d0 = 48;
            d1 = c7;
            h0 = c9;
            h1 = c10;
            i0 = c12;
            i1 = c13;
            s0 = c15;
            s1 = c16;
        } else {
            String input = str.substring(off, off + 17);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            String input = str.substring(off, off + 17);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < 48 || m0 > 57 || m1 < 48 || m1 > 57) {
            String input = str.substring(off, off + 17);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < 48 || d0 > 57 || d1 < '0' || d1 > '9') {
            String input = str.substring(off, off + 17);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (h0 < '0' || h0 > '9' || h1 < '0' || h1 > '9') {
            String input = str.substring(off, off + 17);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < '0' || i0 > '9' || i1 < '0' || i1 > '9') {
            String input = str.substring(off, off + 17);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < 48 || s0 > 57 || s1 < 48 || s1 > 57) {
            String input = str.substring(off, off + 17);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        return LocalDateTime.of(year, month, dom, hour, minute, second);
    }

    public static LocalDateTime parseLocalDateTime18(String str, int off) {
        char s1;
        int s0;
        char i1;
        int i0;
        char h1;
        int h0;
        char d1;
        int d0;
        char m1;
        int m0;
        char y3;
        char y2;
        char y1;
        char y0;
        if (off + 18 > str.length()) {
            String input = str.substring(off);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        char c0 = str.charAt(off + 0);
        char c1 = str.charAt(off + 1);
        char c2 = str.charAt(off + 2);
        char c3 = str.charAt(off + 3);
        char c4 = str.charAt(off + 4);
        char c5 = str.charAt(off + 5);
        char c6 = str.charAt(off + 6);
        int c7 = str.charAt(off + 7);
        char c8 = str.charAt(off + 8);
        char c9 = str.charAt(off + 9);
        int c10 = str.charAt(off + 10);
        char c11 = str.charAt(off + 11);
        char c12 = str.charAt(off + 12);
        int c13 = str.charAt(off + 13);
        char c14 = str.charAt(off + 14);
        char c15 = str.charAt(off + 15);
        int c16 = str.charAt(off + 16);
        char c17 = str.charAt(off + 17);
        if (c4 == '-' && c6 == '-' && (c9 == ' ' || c9 == 'T') && c12 == ':' && c15 == ':') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = 48;
            m1 = c5;
            d0 = c7;
            d1 = c8;
            h0 = c10;
            h1 = c11;
            i0 = c13;
            i1 = c14;
            s0 = c16;
            s1 = c17;
        } else if (c4 == '-' && c7 == 45 && (c9 == ' ' || c9 == 'T') && c12 == ':' && c15 == ':') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = 48;
            d1 = c8;
            h0 = c10;
            h1 = c11;
            i0 = c13;
            i1 = c14;
            s0 = c16;
            s1 = c17;
        } else if (c4 == '-' && c7 == 45 && (c10 == 32 || c10 == 84) && c12 == ':' && c15 == ':') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = 48;
            h1 = c11;
            i0 = c13;
            i1 = c14;
            s0 = c16;
            s1 = c17;
        } else if (c4 == '-' && c7 == 45 && (c10 == 32 || c10 == 84) && c13 == 58 && c15 == ':') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = 48;
            i1 = c14;
            s0 = c16;
            s1 = c17;
        } else if (c4 == '-' && c7 == 45 && (c10 == 32 || c10 == 84) && c13 == 58 && c16 == 58) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = 48;
            s1 = c17;
        } else {
            String input = str.substring(off, off + 18);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            String input = str.substring(off, off + 18);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < 48 || m0 > 57 || m1 < '0' || m1 > '9') {
            String input = str.substring(off, off + 18);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < 48 || d0 > 57 || d1 < '0' || d1 > '9') {
            String input = str.substring(off, off + 18);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (h0 < 48 || h0 > 57 || h1 < '0' || h1 > '9') {
            String input = str.substring(off, off + 18);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < 48 || i0 > 57 || i1 < '0' || i1 > '9') {
            String input = str.substring(off, off + 18);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < 48 || s0 > 57 || s1 < '0' || s1 > '9') {
            String input = str.substring(off, off + 18);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        return LocalDateTime.of(year, month, dom, hour, minute, second);
    }

    public static LocalDateTime parseLocalDateTime19(String str, int off) {
        char s1;
        char s0;
        char i1;
        char i0;
        char h1;
        char h0;
        char d1;
        char d0;
        char m1;
        char m0;
        char y3;
        char y2;
        char y1;
        char y0;
        if (off + 19 > str.length()) {
            String input = str.substring(off);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        char c0 = str.charAt(off + 0);
        char c1 = str.charAt(off + 1);
        char c2 = str.charAt(off + 2);
        char c3 = str.charAt(off + 3);
        char c4 = str.charAt(off + 4);
        char c5 = str.charAt(off + 5);
        char c6 = str.charAt(off + 6);
        char c7 = str.charAt(off + 7);
        char c8 = str.charAt(off + 8);
        char c9 = str.charAt(off + 9);
        char c10 = str.charAt(off + 10);
        char c11 = str.charAt(off + 11);
        char c12 = str.charAt(off + 12);
        char c13 = str.charAt(off + 13);
        char c14 = str.charAt(off + 14);
        char c15 = str.charAt(off + 15);
        char c16 = str.charAt(off + 16);
        char c17 = str.charAt(off + 17);
        char c18 = str.charAt(off + 18);
        if (c4 == '-' && c7 == '-' && (c10 == ' ' || c10 == 'T') && c13 == ':' && c16 == ':') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
        } else if (c4 == '/' && c7 == '/' && (c10 == ' ' || c10 == 'T') && c13 == ':' && c16 == ':') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
        } else if (c2 == '/' && c5 == '/' && (c10 == ' ' || c10 == 'T') && c13 == ':' && c16 == ':') {
            d0 = c0;
            d1 = c1;
            m0 = c3;
            m1 = c4;
            y0 = c6;
            y1 = c7;
            y2 = c8;
            y3 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
        } else {
            String input = str.substring(off, off + 19);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        LocalDateTime ldt = DateUtils.localDateTime(y0, y1, y2, y3, m0, m1, d0, d1, h0, h1, i0, i1, s0, s1, '0', '0', '0', '0', '0', '0', '0', '0', '0');
        if (ldt == null) {
            String input = str.substring(off, off + 19);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        return ldt;
    }

    static LocalDateTime parseLocalDateTimeX(String str, int offset, int len) {
        char c20;
        if (str == null || len == 0) {
            return null;
        }
        if (len < 21 || len > 29) {
            String input = str.substring(offset, len);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        char c0 = str.charAt(offset + 0);
        char c1 = str.charAt(offset + 1);
        char c2 = str.charAt(offset + 2);
        char c3 = str.charAt(offset + 3);
        char c4 = str.charAt(offset + 4);
        char c5 = str.charAt(offset + 5);
        char c6 = str.charAt(offset + 6);
        char c7 = str.charAt(offset + 7);
        char c8 = str.charAt(offset + 8);
        char c9 = str.charAt(offset + 9);
        char c10 = str.charAt(offset + 10);
        char c11 = str.charAt(offset + 11);
        char c12 = str.charAt(offset + 12);
        char c13 = str.charAt(offset + 13);
        char c14 = str.charAt(offset + 14);
        char c15 = str.charAt(offset + 15);
        char c16 = str.charAt(offset + 16);
        char c17 = str.charAt(offset + 17);
        char c18 = str.charAt(offset + 18);
        char c19 = str.charAt(offset + 19);
        char c21 = '0';
        char c22 = '0';
        char c23 = '0';
        char c24 = '0';
        char c25 = '0';
        char c26 = '0';
        char c27 = '0';
        char c28 = '0';
        switch (len) {
            case 21: {
                c20 = str.charAt(offset + 20);
                break;
            }
            case 22: {
                c20 = str.charAt(offset + 20);
                c21 = str.charAt(offset + 21);
                break;
            }
            case 23: {
                c20 = str.charAt(offset + 20);
                c21 = str.charAt(offset + 21);
                c22 = str.charAt(offset + 22);
                break;
            }
            case 24: {
                c20 = str.charAt(offset + 20);
                c21 = str.charAt(offset + 21);
                c22 = str.charAt(offset + 22);
                c23 = str.charAt(offset + 23);
                break;
            }
            case 25: {
                c20 = str.charAt(offset + 20);
                c21 = str.charAt(offset + 21);
                c22 = str.charAt(offset + 22);
                c23 = str.charAt(offset + 23);
                c24 = str.charAt(offset + 24);
                break;
            }
            case 26: {
                c20 = str.charAt(offset + 20);
                c21 = str.charAt(offset + 21);
                c22 = str.charAt(offset + 22);
                c23 = str.charAt(offset + 23);
                c24 = str.charAt(offset + 24);
                c25 = str.charAt(offset + 25);
                break;
            }
            case 27: {
                c20 = str.charAt(offset + 20);
                c21 = str.charAt(offset + 21);
                c22 = str.charAt(offset + 22);
                c23 = str.charAt(offset + 23);
                c24 = str.charAt(offset + 24);
                c25 = str.charAt(offset + 25);
                c26 = str.charAt(offset + 26);
                break;
            }
            case 28: {
                c20 = str.charAt(offset + 20);
                c21 = str.charAt(offset + 21);
                c22 = str.charAt(offset + 22);
                c23 = str.charAt(offset + 23);
                c24 = str.charAt(offset + 24);
                c25 = str.charAt(offset + 25);
                c26 = str.charAt(offset + 26);
                c27 = str.charAt(offset + 27);
                break;
            }
            default: {
                c20 = str.charAt(offset + 20);
                c21 = str.charAt(offset + 21);
                c22 = str.charAt(offset + 22);
                c23 = str.charAt(offset + 23);
                c24 = str.charAt(offset + 24);
                c25 = str.charAt(offset + 25);
                c26 = str.charAt(offset + 26);
                c27 = str.charAt(offset + 27);
                c28 = str.charAt(offset + 28);
            }
        }
        if (c4 != '-' || c7 != '-' || c10 != ' ' && c10 != 'T' || c13 != ':' || c16 != ':' || c19 != '.') {
            String input = str.substring(offset, len);
            throw new DateTimeParseException("illegal input " + input, input, offset);
        }
        char y0 = c0;
        char y1 = c1;
        char y2 = c2;
        char y3 = c3;
        char m0 = c5;
        char m1 = c6;
        char d0 = c8;
        char d1 = c9;
        char h0 = c11;
        char h1 = c12;
        char i0 = c14;
        char i1 = c15;
        char s0 = c17;
        char s1 = c18;
        char S0 = c20;
        char S1 = c21;
        char S2 = c22;
        char S3 = c23;
        char S4 = c24;
        char S5 = c25;
        char S6 = c26;
        char S7 = c27;
        char S8 = c28;
        LocalDateTime ldt = DateUtils.localDateTime(y0, y1, y2, y3, m0, m1, d0, d1, h0, h1, i0, i1, s0, s1, S0, S1, S2, S3, S4, S5, S6, S7, S8);
        if (ldt == null) {
            String input = str.substring(offset, len);
            throw new DateTimeParseException("illegal input " + input, input, offset);
        }
        return ldt;
    }

    public static ZonedDateTime parseZonedDateTime(String str) {
        return DateUtils.parseZonedDateTime(str, 0, str.length(), null);
    }

    public static ZonedDateTime parseZonedDateTime(String str, int offset, int len) {
        return DateUtils.parseZonedDateTime(str, offset, len, null);
    }

    public static ZonedDateTime parseZonedDateTime(String str, int offset, int len, ZoneId defaultZoneId) {
        ZoneId zoneId;
        int zoneIdBegin;
        int S8;
        int S7;
        char S6;
        char S5;
        char S4;
        char S3;
        char S2;
        char S1;
        char S0;
        char s1;
        char s0;
        char i1;
        char i0;
        char h1;
        char h0;
        char d1;
        char d0;
        char m1;
        char m0;
        char y3;
        char y2;
        char y1;
        char y0;
        char c20;
        if (str == null || len == 0) {
            return null;
        }
        if (len < 19) {
            String input = str.substring(offset, len);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        char c0 = str.charAt(offset + 0);
        char c1 = str.charAt(offset + 1);
        char c2 = str.charAt(offset + 2);
        char c3 = str.charAt(offset + 3);
        char c4 = str.charAt(offset + 4);
        char c5 = str.charAt(offset + 5);
        char c6 = str.charAt(offset + 6);
        char c7 = str.charAt(offset + 7);
        char c8 = str.charAt(offset + 8);
        char c9 = str.charAt(offset + 9);
        char c10 = str.charAt(offset + 10);
        char c11 = str.charAt(offset + 11);
        char c12 = str.charAt(offset + 12);
        char c13 = str.charAt(offset + 13);
        char c14 = str.charAt(offset + 14);
        char c15 = str.charAt(offset + 15);
        char c16 = str.charAt(offset + 16);
        char c17 = str.charAt(offset + 17);
        char c18 = str.charAt(offset + 18);
        char c19 = len == 19 ? (char)' ' : (char)str.charAt(offset + 19);
        char c21 = '0';
        char c22 = '0';
        char c23 = '0';
        char c24 = '0';
        char c25 = '0';
        char c26 = '0';
        int c27 = 48;
        int c28 = 48;
        char c29 = '\u0000';
        switch (len) {
            case 19: 
            case 20: {
                c20 = '\u0000';
                break;
            }
            case 21: {
                c20 = str.charAt(offset + 20);
                break;
            }
            case 22: {
                c20 = str.charAt(offset + 20);
                c21 = str.charAt(offset + 21);
                break;
            }
            case 23: {
                c20 = str.charAt(offset + 20);
                c21 = str.charAt(offset + 21);
                c22 = str.charAt(offset + 22);
                break;
            }
            case 24: {
                c20 = str.charAt(offset + 20);
                c21 = str.charAt(offset + 21);
                c22 = str.charAt(offset + 22);
                c23 = str.charAt(offset + 23);
                break;
            }
            case 25: {
                c20 = str.charAt(offset + 20);
                c21 = str.charAt(offset + 21);
                c22 = str.charAt(offset + 22);
                c23 = str.charAt(offset + 23);
                c24 = str.charAt(offset + 24);
                break;
            }
            case 26: {
                c20 = str.charAt(offset + 20);
                c21 = str.charAt(offset + 21);
                c22 = str.charAt(offset + 22);
                c23 = str.charAt(offset + 23);
                c24 = str.charAt(offset + 24);
                c25 = str.charAt(offset + 25);
                break;
            }
            case 27: {
                c20 = str.charAt(offset + 20);
                c21 = str.charAt(offset + 21);
                c22 = str.charAt(offset + 22);
                c23 = str.charAt(offset + 23);
                c24 = str.charAt(offset + 24);
                c25 = str.charAt(offset + 25);
                c26 = str.charAt(offset + 26);
                break;
            }
            case 28: {
                c20 = str.charAt(offset + 20);
                c21 = str.charAt(offset + 21);
                c22 = str.charAt(offset + 22);
                c23 = str.charAt(offset + 23);
                c24 = str.charAt(offset + 24);
                c25 = str.charAt(offset + 25);
                c26 = str.charAt(offset + 26);
                c27 = str.charAt(offset + 27);
                break;
            }
            case 29: {
                c20 = str.charAt(offset + 20);
                c21 = str.charAt(offset + 21);
                c22 = str.charAt(offset + 22);
                c23 = str.charAt(offset + 23);
                c24 = str.charAt(offset + 24);
                c25 = str.charAt(offset + 25);
                c26 = str.charAt(offset + 26);
                c27 = str.charAt(offset + 27);
                c28 = str.charAt(offset + 28);
                break;
            }
            default: {
                c20 = str.charAt(offset + 20);
                c21 = str.charAt(offset + 21);
                c22 = str.charAt(offset + 22);
                c23 = str.charAt(offset + 23);
                c24 = str.charAt(offset + 24);
                c25 = str.charAt(offset + 25);
                c26 = str.charAt(offset + 26);
                c27 = str.charAt(offset + 27);
                c28 = str.charAt(offset + 28);
                c29 = str.charAt(offset + 29);
            }
        }
        boolean isTimeZone = false;
        if (!(c4 != '-' || c7 != '-' || c10 != ' ' && c10 != 'T' || c13 != ':' || c16 != ':' || c19 != '[' && c19 != 'Z' && c19 != '+' && c19 != '-' && c19 != ' ')) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = '0';
            S1 = '0';
            S2 = '0';
            S3 = '0';
            S4 = '0';
            S5 = '0';
            S6 = '0';
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 19;
        } else if (c4 == '-' && c7 == '-' && c10 == ' ' && c11 == ' ' && c14 == ':' && c17 == ':' && len == 20) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c12;
            h1 = c13;
            i0 = c15;
            i1 = c16;
            s0 = c18;
            s1 = c19;
            S0 = '0';
            S1 = '0';
            S2 = '0';
            S3 = '0';
            S4 = '0';
            S5 = '0';
            S6 = '0';
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 20;
        } else if (!(c4 != '-' || c7 != '-' || c10 != ' ' && c10 != 'T' || c13 != ':' || c16 != ':' || c19 != '.' || len != 21 && c21 != '[' && c21 != '+' && c21 != '-' && c21 != 'Z')) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = '0';
            S2 = '0';
            S3 = '0';
            S4 = '0';
            S5 = '0';
            S6 = '0';
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 21;
            isTimeZone = c21 == '|';
        } else if (!(c4 != '-' || c7 != '-' || c10 != ' ' && c10 != 'T' || c13 != ':' || c16 != ':' || c19 != '.' || len != 22 && c22 != '[' && c22 != '+' && c22 != '-' && c22 != 'Z')) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = '0';
            S3 = '0';
            S4 = '0';
            S5 = '0';
            S6 = '0';
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 22;
            isTimeZone = c22 == '|';
        } else if (c4 == '-' && c7 == '-' && (c10 == ' ' || c10 == 'T') && c13 == ':' && c16 == 'Z' && c17 == '[' && len == 22 && c21 == ']') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = '0';
            s1 = '0';
            S0 = '0';
            S1 = '0';
            S2 = '0';
            S3 = '0';
            S4 = '0';
            S5 = '0';
            S6 = '0';
            S7 = 48;
            S8 = 48;
            isTimeZone = true;
            zoneIdBegin = 17;
        } else if (!(c4 != '-' || c7 != '-' || c10 != ' ' && c10 != 'T' || c13 != ':' || c16 != ':' || c19 != '.' || len != 23 && c23 != '[' && c23 != '|' && c23 != '+' && c23 != '-' && c23 != 'Z')) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = '0';
            S4 = '0';
            S5 = '0';
            S6 = '0';
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 23;
            isTimeZone = c23 == '|';
        } else if (!(c4 != '-' || c7 != '-' || c10 != ' ' && c10 != 'T' || c13 != ':' || c16 != ':' || c19 != '.' || len != 24 && c24 != '[' && c24 != '|' && c24 != '+' && c24 != '-' && c24 != 'Z')) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = c23;
            S4 = '0';
            S5 = '0';
            S6 = '0';
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 24;
            isTimeZone = c24 == '|';
        } else if (!(c4 != '-' || c7 != '-' || c10 != ' ' && c10 != 'T' || c13 != ':' || c16 != ':' || c19 != '.' || len != 25 && c25 != '[' && c25 != '|' && c25 != '+' && c25 != '-' && c25 != 'Z')) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = c23;
            S4 = c24;
            S5 = '0';
            S6 = '0';
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 25;
            isTimeZone = c25 == '|';
        } else if (!(c4 != '-' || c7 != '-' || c10 != ' ' && c10 != 'T' || c13 != ':' || c16 != ':' || c19 != '.' || len != 26 && c26 != '[' && c26 != '|' && c26 != '+' && c26 != '-' && c26 != 'Z')) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = c23;
            S4 = c24;
            S5 = c25;
            S6 = '0';
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 26;
            isTimeZone = c26 == '|';
        } else if (!(c4 != '-' || c7 != '-' || c10 != ' ' && c10 != 'T' || c13 != ':' || c16 != ':' || c19 != '.' || len != 27 && c27 != 91 && c27 != 124 && c27 != 43 && c27 != 45 && c27 != 90)) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = c23;
            S4 = c24;
            S5 = c25;
            S6 = c26;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 27;
            isTimeZone = c27 == 124;
        } else if (!(c4 != '-' || c7 != '-' || c10 != ' ' && c10 != 'T' || c13 != ':' || c16 != ':' || c19 != '.' || len != 28 && c28 != 91 && c28 != 124 && c28 != 43 && c28 != 45 && c28 != 90)) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = c23;
            S4 = c24;
            S5 = c25;
            S6 = c26;
            S7 = c27;
            S8 = 48;
            zoneIdBegin = 28;
            isTimeZone = c28 == 124;
        } else if (!(c4 != '-' || c7 != '-' || c10 != ' ' && c10 != 'T' || c13 != ':' || c16 != ':' || c19 != '.' || len != 29 && c29 != '[' && c29 != '|' && c29 != '+' && c29 != '-' && c29 != 'Z')) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = c23;
            S4 = c24;
            S5 = c25;
            S6 = c26;
            S7 = c27;
            S8 = c28;
            zoneIdBegin = 29;
            isTimeZone = c29 == '|';
        } else {
            String input = str.substring(offset, len);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        LocalDateTime ldt = DateUtils.localDateTime(y0, y1, y2, y3, m0, m1, d0, d1, h0, h1, i0, i1, s0, s1, S0, S1, S2, S3, S4, S5, S6, (char)S7, (char)S8);
        if (ldt == null) {
            String input = str.substring(offset, len);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        if (isTimeZone) {
            String tzStr;
            switch (tzStr = str.substring(offset + zoneIdBegin, offset + len)) {
                case "UTC": 
                case "[UTC]": {
                    zoneId = ZoneOffset.UTC;
                    break;
                }
                default: {
                    TimeZone timeZone = TimeZone.getTimeZone(tzStr);
                    zoneId = timeZone.toZoneId();
                    break;
                }
            }
        } else if (zoneIdBegin == len) {
            zoneId = IOUtils.DEFAULT_ZONE_ID;
        } else {
            char first = str.charAt(offset + zoneIdBegin);
            if (first == 'Z') {
                zoneId = ZoneOffset.UTC;
            } else {
                String zoneIdStr = first == '+' || first == '-' ? str.substring(offset + zoneIdBegin, offset + len) : (first == ' ' ? str.substring(offset + zoneIdBegin + 1, offset + len) : (zoneIdBegin < len ? str.substring(offset + zoneIdBegin + 1, offset + len - 1) : null));
                zoneId = DateUtils.getZoneId(zoneIdStr, defaultZoneId);
            }
        }
        return ZonedDateTime.ofLocal(ldt, zoneId, null);
    }

    public static ZoneId getZoneId(String zoneIdStr, ZoneId defaultZoneId) {
        ZoneId zoneId;
        if (zoneIdStr == null) {
            return defaultZoneId != null ? defaultZoneId : IOUtils.DEFAULT_ZONE_ID;
        }
        if ("000".equals(zoneIdStr)) {
            zoneId = ZoneOffset.UTC;
        } else {
            int p1;
            int p0 = zoneIdStr.indexOf(91);
            if (p0 > 0 && (p1 = zoneIdStr.indexOf(93, p0)) > 0) {
                String str = zoneIdStr.substring(p0 + 1, p1);
                zoneId = ZoneId.of(str);
            } else {
                zoneId = ZoneId.of(zoneIdStr);
            }
        }
        return zoneId;
    }

    public static long toMillis19(String str, int off, ZoneId zoneId) {
        int dom;
        int month;
        char s1;
        char s0;
        char i1;
        char i0;
        char h1;
        char h0;
        char d1;
        char d0;
        char m1;
        char m0;
        char y3;
        char y2;
        char y1;
        char y0;
        if (str == null) {
            throw new NullPointerException();
        }
        if (off + 19 > str.length()) {
            String input = str.substring(off);
            throw new DateTimeParseException("illegal input " + input, input, 0);
        }
        char c0 = str.charAt(off + 0);
        char c1 = str.charAt(off + 1);
        char c2 = str.charAt(off + 2);
        char c3 = str.charAt(off + 3);
        char c4 = str.charAt(off + 4);
        char c5 = str.charAt(off + 5);
        char c6 = str.charAt(off + 6);
        char c7 = str.charAt(off + 7);
        char c8 = str.charAt(off + 8);
        char c9 = str.charAt(off + 9);
        char c10 = str.charAt(off + 10);
        char c11 = str.charAt(off + 11);
        char c12 = str.charAt(off + 12);
        char c13 = str.charAt(off + 13);
        char c14 = str.charAt(off + 14);
        char c15 = str.charAt(off + 15);
        char c16 = str.charAt(off + 16);
        char c17 = str.charAt(off + 17);
        char c18 = str.charAt(off + 18);
        if (c4 == '-' && c7 == '-' && (c10 == ' ' || c10 == 'T') && c13 == ':' && c16 == ':') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
        } else if (c4 == '/' && c7 == '/' && (c10 == ' ' || c10 == 'T') && c13 == ':' && c16 == ':') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
        } else {
            throw new DateTimeParseException("illegal input", str.substring(off, off + 19), 0);
        }
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            throw new DateTimeParseException("illegal input", str.substring(off, off + 19), 0);
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 >= '0' && m0 <= '9' && m1 >= '0' && m1 <= '9') {
            month = (m0 - 48) * 10 + (m1 - 48);
            if (month == 0 && year != 0 || month > 12) {
                throw new DateTimeParseException("illegal input", str.substring(off, off + 19), 0);
            }
        } else {
            throw new DateTimeParseException("illegal input", str.substring(off, off + 19), 0);
        }
        if (d0 >= '0' && d0 <= '9' && d1 >= '0' && d1 <= '9') {
            dom = (d0 - 48) * 10 + (d1 - 48);
            int max = 31;
            switch (month) {
                case 2: {
                    boolean leapYear = (year & 3) == 0 && (year % 100 != 0 || year % 400 == 0);
                    max = leapYear ? 29 : 28;
                    break;
                }
                case 4: 
                case 6: 
                case 9: 
                case 11: {
                    max = 30;
                }
            }
            if (dom == 0 && year != 0 || dom > max) {
                throw new DateTimeParseException("illegal input", str.substring(off, off + 19), 0);
            }
        } else {
            throw new DateTimeParseException("illegal input", str.substring(off, off + 19), 0);
        }
        if (h0 < '0' || h0 > '9' || h1 < '0' || h1 > '9') {
            throw new DateTimeParseException("illegal input", str.substring(off, off + 19), 0);
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < '0' || i0 > '9' || i1 < '0' || i1 > '9') {
            throw new DateTimeParseException("illegal input", str.substring(off, off + 19), 0);
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < '0' || s0 > '9' || s1 < '0' || s1 > '9') {
            throw new DateTimeParseException("illegal input", str.substring(off, off + 19), 0);
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        if (year == 0 && month == 0 && dom == 0) {
            year = 1970;
            month = 1;
            dom = 1;
        }
        return DateUtils.millis(zoneId, year, month, dom, hour, minute, second, 0);
    }

    public static LocalDateTime localDateTime(char y0, char y1, char y2, char y3, char m0, char m1, char d0, char d1, char h0, char h1, char i0, char i1, char s0, char s1, char S0, char S1, char S2, char S3, char S4, char S5, char S6, char S7, char S8) {
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < '0' || m0 > '9' || m1 < '0' || m1 > '9') {
            return null;
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < '0' || d0 > '9' || d1 < '0' || d1 > '9') {
            return null;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (h0 < '0' || h0 > '9' || h1 < '0' || h1 > '9') {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < '0' || i0 > '9' || i1 < '0' || i1 > '9') {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < '0' || s0 > '9' || s1 < '0' || s1 > '9') {
            return null;
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        if (S0 < '0' || S0 > '9' || S1 < '0' || S1 > '9' || S2 < '0' || S2 > '9' || S3 < '0' || S3 > '9' || S4 < '0' || S4 > '9' || S5 < '0' || S5 > '9' || S6 < '0' || S6 > '9' || S7 < '0' || S7 > '9' || S8 < '0' || S8 > '9') {
            return null;
        }
        int nanos = (S0 - 48) * 100000000 + (S1 - 48) * 10000000 + (S2 - 48) * 1000000 + (S3 - 48) * 100000 + (S4 - 48) * 10000 + (S5 - 48) * 1000 + (S6 - 48) * 100 + (S7 - 48) * 10 + (S8 - 48);
        LocalDateTime ldt = LocalDateTime.of(year, month, dom, hour, minute, second, nanos);
        return ldt;
    }

    public static long millis(ZoneId zoneId, int year, int month, int dom, int hour, int minute, int second, int nanoOfSecond) {
        if (zoneId == null) {
            zoneId = IOUtils.DEFAULT_ZONE_ID;
        }
        if (zoneId == IOUtils.SHANGHAI_ZONE_ID || zoneId.getRules() == IOUtils.SHANGHAI_ZONE_RULES) {
            long SECONDS_1991_09_15_02 = 684900000L;
            long SECONDS_1991_04_14_03 = 671598000L;
            long SECONDS_1990_09_16_02 = 653450400L;
            long SECONDS_1990_04_15_03 = 640148400L;
            long SECONDS_1989_09_17_02 = 622000800L;
            long SECONDS_1989_04_16_03 = 608698800L;
            long SECONDS_1988_09_11_02 = 589946400L;
            long SECONDS_1988_04_17_03 = 577249200L;
            long SECONDS_1987_09_13_02 = 558496800L;
            long SECONDS_1987_04_12_03 = 545194800L;
            long SECONDS_1986_09_14_02 = 527047200L;
            long SECONDS_1986_05_04_03 = 515559600L;
            long SECONDS_1949_05_28_00 = -649987200L;
            long SECONDS_1949_05_01_01 = -652316400L;
            long SECONDS_1948_10_01_00 = -670636800L;
            long SECONDS_1948_05_01_01 = -683852400L;
            long SECONDS_1947_11_01_00 = -699580800L;
            long SECONDS_1947_04_15_01 = -716857200L;
            long SECONDS_1946_10_01_00 = -733795200L;
            long SECONDS_1946_05_15_01 = -745801200L;
            long SECONDS_1945_09_02_00 = -767836800L;
            long SECONDS_1942_01_31_01 = -881017200L;
            long SECONDS_1941_11_02_00 = -888796800L;
            long SECONDS_1941_03_15_01 = -908838000L;
            long SECONDS_1940_10_13_00 = -922060800L;
            long SECONDS_1940_06_01_01 = -933634800L;
            long SECONDS_1919_10_01_00 = -1585872000L;
            long SECONDS_1919_04_13_01 = -1600642800L;
            long SECONDS_1901_01_01_00 = -2177452800L;
            int OFFSET_0900_TOTAL_SECONDS = 32400;
            int OFFSET_0543_TOTAL_SECONDS = 29143;
            long seconds = DateUtils.utcSeconds(year, month, dom, hour, minute, second);
            int zoneOffsetTotalSeconds = seconds >= SECONDS_1991_09_15_02 ? 28800 : (seconds >= SECONDS_1991_04_14_03 ? 32400 : (seconds >= SECONDS_1990_09_16_02 ? 28800 : (seconds >= SECONDS_1990_04_15_03 ? 32400 : (seconds >= SECONDS_1989_09_17_02 ? 28800 : (seconds >= SECONDS_1989_04_16_03 ? 32400 : (seconds >= SECONDS_1988_09_11_02 ? 28800 : (seconds >= SECONDS_1988_04_17_03 ? 32400 : (seconds >= SECONDS_1987_09_13_02 ? 28800 : (seconds >= SECONDS_1987_04_12_03 ? 32400 : (seconds >= SECONDS_1986_09_14_02 ? 28800 : (seconds >= SECONDS_1986_05_04_03 ? 32400 : (seconds >= SECONDS_1949_05_28_00 ? 28800 : (seconds >= SECONDS_1949_05_01_01 ? 32400 : (seconds >= SECONDS_1948_10_01_00 ? 28800 : (seconds >= SECONDS_1948_05_01_01 ? 32400 : (seconds >= SECONDS_1947_11_01_00 ? 28800 : (seconds >= SECONDS_1947_04_15_01 ? 32400 : (seconds >= SECONDS_1946_10_01_00 ? 28800 : (seconds >= SECONDS_1946_05_15_01 ? 32400 : (seconds >= SECONDS_1945_09_02_00 ? 28800 : (seconds >= SECONDS_1942_01_31_01 ? 32400 : (seconds >= SECONDS_1941_11_02_00 ? 28800 : (seconds >= SECONDS_1941_03_15_01 ? 32400 : (seconds >= SECONDS_1940_10_13_00 ? 28800 : (seconds >= SECONDS_1940_06_01_01 ? 32400 : (seconds >= SECONDS_1919_10_01_00 ? 28800 : (seconds >= SECONDS_1919_04_13_01 ? 32400 : (seconds >= SECONDS_1901_01_01_00 ? 28800 : 29143))))))))))))))))))))))))))));
            return (seconds -= (long)zoneOffsetTotalSeconds) * 1000L + (long)(nanoOfSecond / 1000000);
        }
        if (zoneId == ZoneOffset.UTC || "UTC".equals(zoneId.getId())) {
            long seconds = DateUtils.utcSeconds(year, month, dom, hour, minute, second);
            return seconds * 1000L + (long)(nanoOfSecond / 1000000);
        }
        LocalDate localDate = LocalDate.of(year, month, dom);
        LocalTime localTime = LocalTime.of(hour, minute, second, nanoOfSecond);
        LocalDateTime ldt = LocalDateTime.of(localDate, localTime);
        ZonedDateTime zdt = ZonedDateTime.ofLocal(ldt, zoneId, null);
        long seconds = zdt.toEpochSecond();
        int nanos = nanoOfSecond;
        if (seconds < 0L && nanos > 0) {
            return (seconds + 1L) * 1000L + (long)(nanos / 1000000) - 1000L;
        }
        return seconds * 1000L + (long)(nanos / 1000000);
    }

    public static long utcSeconds(int year, int month, int dom, int hour, int minute, int second) {
        int DAYS_PER_CYCLE = 146097;
        long DAYS_0000_TO_1970 = 719528L;
        long total = 365 * year + ((year + 3) / 4 - (year + 99) / 100 + (year + 399) / 400) + (367 * month - 362) / 12 + (dom - 1);
        if (month > 2) {
            boolean leapYear;
            --total;
            boolean bl = leapYear = (year & 3) == 0 && (year % 100 != 0 || year % 400 == 0);
            if (!leapYear) {
                --total;
            }
        }
        long epochDay = total - 719528L;
        return epochDay * 86400L + (long)(hour * 3600) + (long)(minute * 60) + (long)second;
    }

    public static String toString(Date date) {
        return DateUtils.toString(date.getTime(), false, IOUtils.DEFAULT_ZONE_ID);
    }

    public static String toString(long timeMillis, boolean timeZone, ZoneId zoneId) {
        int offsetAbs;
        int timeZoneOffset;
        int i;
        long yearEst;
        long doyEst;
        int offsetTotalSeconds;
        int SECONDS_PER_DAY = 86400;
        long epochSecond = Math.floorDiv(timeMillis, 1000L);
        if (zoneId == IOUtils.SHANGHAI_ZONE_ID || zoneId.getRules() == IOUtils.SHANGHAI_ZONE_RULES) {
            offsetTotalSeconds = IOUtils.getShanghaiZoneOffsetTotalSeconds(epochSecond);
        } else {
            Instant instant = Instant.ofEpochMilli(timeMillis);
            offsetTotalSeconds = zoneId.getRules().getOffset(instant).getTotalSeconds();
        }
        long localSecond = epochSecond + (long)offsetTotalSeconds;
        long localEpochDay = Math.floorDiv(localSecond, 86400L);
        int secsOfDay = (int)Math.floorMod(localSecond, 86400L);
        int DAYS_PER_CYCLE = 146097;
        long DAYS_0000_TO_1970 = 719528L;
        long zeroDay = localEpochDay + 719528L;
        long adjust = 0L;
        if ((zeroDay -= 60L) < 0L) {
            long adjustCycles = (zeroDay + 1L) / 146097L - 1L;
            adjust = adjustCycles * 400L;
            zeroDay += -adjustCycles * 146097L;
        }
        if ((doyEst = zeroDay - (365L * (yearEst = (400L * zeroDay + 591L) / 146097L) + yearEst / 4L - yearEst / 100L + yearEst / 400L)) < 0L) {
            doyEst = zeroDay - (365L * --yearEst + yearEst / 4L - yearEst / 100L + yearEst / 400L);
        }
        yearEst += adjust;
        int marchDoy0 = (int)doyEst;
        int marchMonth0 = (marchDoy0 * 5 + 2) / 153;
        int month = (marchMonth0 + 2) % 12 + 1;
        int dayOfMonth = marchDoy0 - (marchMonth0 * 306 + 5) / 10 + 1;
        if ((yearEst += (long)(marchMonth0 / 10)) < -999999999L || yearEst > 999999999L) {
            throw new DateTimeException("Invalid year " + yearEst);
        }
        int year = (int)yearEst;
        int MINUTES_PER_HOUR = 60;
        int SECONDS_PER_MINUTE = 60;
        int SECONDS_PER_HOUR = 3600;
        long secondOfDay = secsOfDay;
        if (secondOfDay < 0L || secondOfDay > 86399L) {
            throw new DateTimeException("Invalid secondOfDay " + secondOfDay);
        }
        int hours = (int)(secondOfDay / 3600L);
        int minutes = (int)((secondOfDay -= (long)(hours * 3600)) / 60L);
        int hour = hours;
        int minute = minutes;
        int second = (int)(secondOfDay -= (long)(minutes * 60));
        int millis = (int)Math.floorMod(timeMillis, 1000L);
        int millislen = millis == 0 ? 0 : (millis < 10 ? 4 : (millis % 100 == 0 ? 2 : (millis % 10 == 0 ? 3 : 4)));
        int zonelen = timeZone ? (offsetTotalSeconds == 0 ? 1 : 6) : 0;
        int len = 19 + millislen + zonelen;
        if (JDKUtils.STRING_CREATOR_JDK8 != null) {
            char[] chars = new char[len];
            chars[0] = (char)(year / 1000 + 48);
            chars[1] = (char)(year / 100 % 10 + 48);
            chars[2] = (char)(year / 10 % 10 + 48);
            chars[3] = (char)(year % 10 + 48);
            chars[4] = 45;
            chars[5] = (char)(month / 10 + 48);
            chars[6] = (char)(month % 10 + 48);
            chars[7] = 45;
            chars[8] = (char)(dayOfMonth / 10 + 48);
            chars[9] = (char)(dayOfMonth % 10 + 48);
            chars[10] = 32;
            chars[11] = (char)(hour / 10 + 48);
            chars[12] = (char)(hour % 10 + 48);
            chars[13] = 58;
            chars[14] = (char)(minute / 10 + 48);
            chars[15] = (char)(minute % 10 + 48);
            chars[16] = 58;
            chars[17] = (char)(second / 10 + 48);
            chars[18] = (char)(second % 10 + 48);
            if (millislen > 0) {
                chars[19] = 46;
                for (i = 20; i < len; ++i) {
                    chars[i] = 48;
                }
                if (millis < 10) {
                    IOUtils.getChars(millis, 19 + millislen, chars);
                } else if (millis % 100 == 0) {
                    IOUtils.getChars(millis / 100, 19 + millislen, chars);
                } else if (millis % 10 == 0) {
                    IOUtils.getChars(millis / 10, 19 + millislen, chars);
                } else {
                    IOUtils.getChars(millis, 19 + millislen, chars);
                }
            }
            if (timeZone) {
                timeZoneOffset = offsetTotalSeconds / 3600;
                if (offsetTotalSeconds == 0) {
                    chars[19 + millislen] = 90;
                } else {
                    offsetAbs = Math.abs(timeZoneOffset);
                    chars[19 + millislen] = timeZoneOffset >= 0 ? 43 : 45;
                    chars[19 + millislen + 1] = 48;
                    IOUtils.getChars(offsetAbs, 19 + millislen + 3, chars);
                    chars[19 + millislen + 3] = 58;
                    chars[19 + millislen + 4] = 48;
                    int offsetMinutes = (offsetTotalSeconds - timeZoneOffset * 3600) / 60;
                    if (offsetMinutes < 0) {
                        offsetMinutes = -offsetMinutes;
                    }
                    IOUtils.getChars(offsetMinutes, 19 + millislen + zonelen, chars);
                }
            }
            return JDKUtils.STRING_CREATOR_JDK8.apply(chars, Boolean.TRUE);
        }
        byte[] bytes = new byte[len];
        bytes[0] = (byte)(year / 1000 + 48);
        bytes[1] = (byte)(year / 100 % 10 + 48);
        bytes[2] = (byte)(year / 10 % 10 + 48);
        bytes[3] = (byte)(year % 10 + 48);
        bytes[4] = 45;
        bytes[5] = (byte)(month / 10 + 48);
        bytes[6] = (byte)(month % 10 + 48);
        bytes[7] = 45;
        bytes[8] = (byte)(dayOfMonth / 10 + 48);
        bytes[9] = (byte)(dayOfMonth % 10 + 48);
        bytes[10] = 32;
        bytes[11] = (byte)(hour / 10 + 48);
        bytes[12] = (byte)(hour % 10 + 48);
        bytes[13] = 58;
        bytes[14] = (byte)(minute / 10 + 48);
        bytes[15] = (byte)(minute % 10 + 48);
        bytes[16] = 58;
        bytes[17] = (byte)(second / 10 + 48);
        bytes[18] = (byte)(second % 10 + 48);
        if (millislen > 0) {
            bytes[19] = 46;
            for (i = 20; i < len; ++i) {
                bytes[i] = 48;
            }
            if (millis < 10) {
                IOUtils.getChars(millis, 19 + millislen, bytes);
            } else if (millis % 100 == 0) {
                IOUtils.getChars(millis / 100, 19 + millislen, bytes);
            } else if (millis % 10 == 0) {
                IOUtils.getChars(millis / 10, 19 + millislen, bytes);
            } else {
                IOUtils.getChars(millis, 19 + millislen, bytes);
            }
        }
        if (timeZone) {
            timeZoneOffset = offsetTotalSeconds / 3600;
            if (offsetTotalSeconds == 0) {
                bytes[19 + millislen] = 90;
            } else {
                offsetAbs = Math.abs(timeZoneOffset);
                bytes[19 + millislen] = timeZoneOffset >= 0 ? 43 : 45;
                bytes[19 + millislen + 1] = 48;
                IOUtils.getChars(offsetAbs, 19 + millislen + 3, bytes);
                bytes[19 + millislen + 3] = 58;
                bytes[19 + millislen + 4] = 48;
                int offsetMinutes = (offsetTotalSeconds - timeZoneOffset * 3600) / 60;
                if (offsetMinutes < 0) {
                    offsetMinutes = -offsetMinutes;
                }
                IOUtils.getChars(offsetMinutes, 19 + millislen + zonelen, bytes);
            }
        }
        if (JDKUtils.STRING_CREATOR_JDK11 != null) {
            return JDKUtils.STRING_CREATOR_JDK11.apply(bytes, JDKUtils.LATIN1);
        }
        return new String(bytes, 0, bytes.length, StandardCharsets.ISO_8859_1);
    }
}

