/*
 * Decompiled with CFR 0.152.
 */
package com.akathist.maven.plugins.launch4j;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public final class FileUtils {
    public static final int DEF_BUF_SIZE = 4096;

    public static byte[] readResourceAsBytes(String resName) throws IOException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
        InputStream is = cl.getResourceAsStream(resName);
        return FileUtils.readAllBytes(is);
    }

    public static byte[] readBytes(File inFile) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FileInputStream fis = new FileInputStream(inFile);
        BufferedInputStream bis = new BufferedInputStream(fis);
        return FileUtils.readAllBytes(bis);
    }

    public static byte[] readAllBytes(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        int bytesRead = 0;
        while ((bytesRead = is.read(buf)) != -1) {
            baos.write(buf, 0, bytesRead);
        }
        return baos.toByteArray();
    }

    public static void writeBytesIfDiff(File outFile, byte[] outBytes) throws IOException {
        byte[] existingBytes;
        if (outFile.exists() && Arrays.equals(outBytes, existingBytes = FileUtils.readBytes(outFile))) {
            return;
        }
        FileUtils.writeBytes(outFile, outBytes);
    }

    public static void writeBytes(File outFile, byte[] outBytes) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(outFile, false);
             BufferedOutputStream bos = new BufferedOutputStream(fos);){
            bos.write(outBytes);
            bos.flush();
        }
    }
}

