/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.security.QueryApiKeysResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class QueryApiKeysRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final Integer from;
    @Nullable
    private final Query query;
    private final List<String> searchAfter;
    @Nullable
    private final Integer size;
    private final List<SortOptions> sort;
    public static final JsonpDeserializer<QueryApiKeysRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, QueryApiKeysRequest::setupQueryApiKeysRequestDeserializer);
    public static final Endpoint<QueryApiKeysRequest, QueryApiKeysResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<QueryApiKeysRequest, QueryApiKeysResponse>("es/security.query_api_keys", request -> "POST", request -> "/_security/_query/api_key", request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, QueryApiKeysResponse._DESERIALIZER);

    private QueryApiKeysRequest(Builder builder) {
        this.from = builder.from;
        this.query = builder.query;
        this.searchAfter = ApiTypeHelper.unmodifiable(builder.searchAfter);
        this.size = builder.size;
        this.sort = ApiTypeHelper.unmodifiable(builder.sort);
    }

    public static QueryApiKeysRequest of(Function<Builder, ObjectBuilder<QueryApiKeysRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Integer from() {
        return this.from;
    }

    @Nullable
    public final Query query() {
        return this.query;
    }

    public final List<String> searchAfter() {
        return this.searchAfter;
    }

    @Nullable
    public final Integer size() {
        return this.size;
    }

    public final List<SortOptions> sort() {
        return this.sort;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.from != null) {
            generator.writeKey("from");
            generator.write(this.from.intValue());
        }
        if (this.query != null) {
            generator.writeKey("query");
            this.query.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.searchAfter)) {
            generator.writeKey("search_after");
            generator.writeStartArray();
            for (String string : this.searchAfter) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size.intValue());
        }
        if (ApiTypeHelper.isDefined(this.sort)) {
            generator.writeKey("sort");
            generator.writeStartArray();
            for (SortOptions sortOptions : this.sort) {
                sortOptions.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupQueryApiKeysRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::from, JsonpDeserializer.integerDeserializer(), "from");
        op.add(Builder::query, Query._DESERIALIZER, "query");
        op.add(Builder::searchAfter, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "search_after");
        op.add(Builder::size, JsonpDeserializer.integerDeserializer(), "size");
        op.add(Builder::sort, JsonpDeserializer.arrayDeserializer(SortOptions._DESERIALIZER), "sort");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<QueryApiKeysRequest> {
        @Nullable
        private Integer from;
        @Nullable
        private Query query;
        @Nullable
        private List<String> searchAfter;
        @Nullable
        private Integer size;
        @Nullable
        private List<SortOptions> sort;

        public final Builder from(@Nullable Integer value) {
            this.from = value;
            return this;
        }

        public final Builder query(@Nullable Query value) {
            this.query = value;
            return this;
        }

        public final Builder query(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.query(fn.apply(new Query.Builder()).build());
        }

        public final Builder searchAfter(List<String> list) {
            this.searchAfter = Builder._listAddAll(this.searchAfter, list);
            return this;
        }

        public final Builder searchAfter(String value, String ... values) {
            this.searchAfter = Builder._listAdd(this.searchAfter, value, values);
            return this;
        }

        public final Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        public final Builder sort(List<SortOptions> list) {
            this.sort = Builder._listAddAll(this.sort, list);
            return this;
        }

        public final Builder sort(SortOptions value, SortOptions ... values) {
            this.sort = Builder._listAdd(this.sort, value, values);
            return this;
        }

        public final Builder sort(Function<SortOptions.Builder, ObjectBuilder<SortOptions>> fn) {
            return this.sort(fn.apply(new SortOptions.Builder()).build(), new SortOptions[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public QueryApiKeysRequest build() {
            this._checkSingleUse();
            return new QueryApiKeysRequest(this);
        }
    }
}

