/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ApiKey
implements JsonpSerializable {
    @Nullable
    private final Long creation;
    @Nullable
    private final Long expiration;
    private final String id;
    @Nullable
    private final Boolean invalidated;
    private final String name;
    @Nullable
    private final String realm;
    @Nullable
    private final String username;
    private final Map<String, JsonData> metadata;
    public static final JsonpDeserializer<ApiKey> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ApiKey::setupApiKeyDeserializer);

    private ApiKey(Builder builder) {
        this.creation = builder.creation;
        this.expiration = builder.expiration;
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.invalidated = builder.invalidated;
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.realm = builder.realm;
        this.username = builder.username;
        this.metadata = ApiTypeHelper.unmodifiable(builder.metadata);
    }

    public static ApiKey of(Function<Builder, ObjectBuilder<ApiKey>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Long creation() {
        return this.creation;
    }

    @Nullable
    public final Long expiration() {
        return this.expiration;
    }

    public final String id() {
        return this.id;
    }

    @Nullable
    public final Boolean invalidated() {
        return this.invalidated;
    }

    public final String name() {
        return this.name;
    }

    @Nullable
    public final String realm() {
        return this.realm;
    }

    @Nullable
    public final String username() {
        return this.username;
    }

    public final Map<String, JsonData> metadata() {
        return this.metadata;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.creation != null) {
            generator.writeKey("creation");
            generator.write(this.creation.longValue());
        }
        if (this.expiration != null) {
            generator.writeKey("expiration");
            generator.write(this.expiration.longValue());
        }
        generator.writeKey("id");
        generator.write(this.id);
        if (this.invalidated != null) {
            generator.writeKey("invalidated");
            generator.write(this.invalidated.booleanValue());
        }
        generator.writeKey("name");
        generator.write(this.name);
        if (this.realm != null) {
            generator.writeKey("realm");
            generator.write(this.realm);
        }
        if (this.username != null) {
            generator.writeKey("username");
            generator.write(this.username);
        }
        if (ApiTypeHelper.isDefined(this.metadata)) {
            generator.writeKey("metadata");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.metadata.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupApiKeyDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::creation, JsonpDeserializer.longDeserializer(), "creation");
        op.add(Builder::expiration, JsonpDeserializer.longDeserializer(), "expiration");
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id");
        op.add(Builder::invalidated, JsonpDeserializer.booleanDeserializer(), "invalidated");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::realm, JsonpDeserializer.stringDeserializer(), "realm");
        op.add(Builder::username, JsonpDeserializer.stringDeserializer(), "username");
        op.add(Builder::metadata, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "metadata");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ApiKey> {
        @Nullable
        private Long creation;
        @Nullable
        private Long expiration;
        private String id;
        @Nullable
        private Boolean invalidated;
        private String name;
        @Nullable
        private String realm;
        @Nullable
        private String username;
        @Nullable
        private Map<String, JsonData> metadata;

        public final Builder creation(@Nullable Long value) {
            this.creation = value;
            return this;
        }

        public final Builder expiration(@Nullable Long value) {
            this.expiration = value;
            return this;
        }

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        public final Builder invalidated(@Nullable Boolean value) {
            this.invalidated = value;
            return this;
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder realm(@Nullable String value) {
            this.realm = value;
            return this;
        }

        public final Builder username(@Nullable String value) {
            this.username = value;
            return this;
        }

        public final Builder metadata(Map<String, JsonData> map) {
            this.metadata = Builder._mapPutAll(this.metadata, map);
            return this;
        }

        public final Builder metadata(String key, JsonData value) {
            this.metadata = Builder._mapPut(this.metadata, key, value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ApiKey build() {
            this._checkSingleUse();
            return new ApiKey(this);
        }
    }
}

