/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.MultiBucketBase;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class CompositeBucket
extends MultiBucketBase {
    private final Map<String, JsonData> key;
    public static final JsonpDeserializer<CompositeBucket> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CompositeBucket::setupCompositeBucketDeserializer);

    private CompositeBucket(Builder builder) {
        super(builder);
        this.key = ApiTypeHelper.unmodifiableRequired(builder.key, (Object)this, "key");
    }

    public static CompositeBucket of(Function<Builder, ObjectBuilder<CompositeBucket>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, JsonData> key() {
        return this.key;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.key)) {
            generator.writeKey("key");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.key.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupCompositeBucketDeserializer(ObjectDeserializer<Builder> op) {
        MultiBucketBase.setupMultiBucketBaseDeserializer(op);
        op.add(Builder::key, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "key");
    }

    public static class Builder
    extends MultiBucketBase.AbstractBuilder<Builder>
    implements ObjectBuilder<CompositeBucket> {
        private Map<String, JsonData> key;

        public final Builder key(Map<String, JsonData> map) {
            this.key = Builder._mapPutAll(this.key, map);
            return this;
        }

        public final Builder key(String key, JsonData value) {
            this.key = Builder._mapPut(this.key, key, value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CompositeBucket build() {
            this._checkSingleUse();
            return new CompositeBucket(this);
        }
    }
}

