/*
 * Decompiled with CFR 0.152.
 */
package cn.zvo.log.datasource.file;

import cn.zvo.log.DatasourceInterface;
import cn.zvo.log.vo.LogListVO;
import cn.zvo.page.Page;
import com.xnx3.DateUtil;
import com.xnx3.FileUtil;
import com.xnx3.StringUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class FileDataSource
implements DatasourceInterface {
    public String path;

    public FileDataSource(String path) {
        this.setPath(path);
    }

    public FileDataSource(Map<String, String> config) {
        if (config == null) {
            return;
        }
        this.setPath(config.get("path"));
    }

    private void setPath(String path) {
        this.path = path == null || path.trim().equals("") ? null : path;
    }

    @Override
    public boolean commit(String table, List<Map<String, Object>> list) {
        if (this.path == null || this.path.equals("")) {
            return true;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            Map<String, Object> map = list.get(i);
            sb.append(JSONObject.fromObject(map).toString() + "\n");
        }
        if (sb.length() > 0) {
            FileUtil.appendText((File)new File(this.path + table + "_" + DateUtil.currentDate((String)"yyyy-MM-dd") + ".log"), (String)sb.toString());
        }
        return true;
    }

    @Override
    public LogListVO list(String table, String query, int everyPageNumber, int currentPage) {
        Scanner sc;
        LogListVO vo = new LogListVO();
        if (query != null && query.trim().length() > 0) {
            vo.setBaseVO(0, "log\u91c7\u7528\u9ed8\u8ba4\u7684\u6587\u4ef6\u5b58\u50a8\u65b9\u5f0f\uff0c\u65e0\u6cd5\u6839\u636e\u67e5\u8be2\u6761\u4ef6\u7b5b\u9009");
            return vo;
        }
        String logPath = this.path + table + "_" + DateUtil.currentDate((String)"yyyy-MM-dd") + ".log";
        File file = new File(logPath);
        if (!file.exists()) {
            vo.setBaseVO(0, "log\u91c7\u7528\u9ed8\u8ba4\u7684\u6587\u4ef6\u5b58\u50a8\u65b9\u5f0f\uff0c\u5f53\u5929\u7684\u65e5\u5fd7\u6587\u4ef6\u5c1a\u4e0d\u5b58\u5728");
            return vo;
        }
        try {
            sc = new Scanner(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            vo.setBaseVO(0, "log\u91c7\u7528\u9ed8\u8ba4\u7684\u6587\u4ef6\u5b58\u50a8\u65b9\u5f0f\uff0c\u4f46\u5f53\u5929\u7684\u65e5\u5fd7\u6587\u4ef6\u5c1a\u4e0d\u5b58\u5728");
            return vo;
        }
        int i = 0;
        LinkedList<String> list = new LinkedList<String>();
        while (i++ < 3001 && sc.hasNext()) {
            String line = sc.nextLine();
            list.add(line);
        }
        vo.setPage(new Page(list.size(), everyPageNumber, currentPage));
        Collections.reverse(list);
        LinkedList resultList = new LinkedList();
        for (int j = 0; j < vo.getPage().getEveryNumber(); ++j) {
            int index = vo.getPage().getLimitStart() + j;
            if (index >= vo.getPage().getAllRecordNumber()) continue;
            resultList.add(list.get(index));
        }
        vo.setJsonArray(JSONArray.fromObject(resultList));
        vo.setPage(new Page(list.size(), everyPageNumber, currentPage));
        vo.setInfo("\u6700\u5927\u663e\u793a3000\u6761");
        return vo;
    }

    public static void directoryInit(String path) {
        if (path == null) {
            return;
        }
        if (path.indexOf("\\") > 1) {
            path = StringUtil.replaceAll((String)path, (String)"\\\\", (String)"/");
        }
        if (path.length() - path.lastIndexOf("/") > 1) {
            path = path.substring(0, path.lastIndexOf("/") + 1);
        }
        if (!new File(path).exists()) {
            String[] ps = path.split("/");
            String xiangdui = "";
            for (int i = 0; i < ps.length; ++i) {
                File file;
                if (ps[i].length() <= 0 || (file = new File(xiangdui = xiangdui + ps[i] + "/")).exists()) continue;
                file.mkdir();
            }
        }
    }

    public static void main(String[] args) {
        FileDataSource.directoryInit("C:\\Users\\Administrator\\Desktop\\log1\\");
    }
}

