/*
 * Decompiled with CFR 0.152.
 */
package cn.zvo.log;

import cn.zvo.log.DatasourceInterface;
import cn.zvo.log.datasource.file.FileDataSource;
import cn.zvo.log.vo.LogListVO;
import com.xnx3.DateUtil;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Log {
    public DatasourceInterface datasource = null;
    public int cacheMaxNumber = 100;
    public int cacheMaxTime = 60;
    public long lastSubmitTime = 0L;
    public Map<String, List<Map<String, Object>>> cacheMap = new HashMap<String, List<Map<String, Object>>>();
    public String table;

    public DatasourceInterface getLogInterface() {
        return this.getDatasource();
    }

    public void setLogInterface(DatasourceInterface datasource) {
        this.setDatasource(datasource);
    }

    public DatasourceInterface getDatasource() {
        if (this.datasource == null) {
            this.datasource = new FileDataSource("");
        }
        return this.datasource;
    }

    public void setDatasource(DatasourceInterface datasource) {
        this.datasource = datasource;
    }

    public int getCacheMaxNumber() {
        return this.cacheMaxNumber;
    }

    public void setCacheMaxNumber(int cacheMaxNumber) {
        this.cacheMaxNumber = cacheMaxNumber;
    }

    public int getCacheMaxTime() {
        return this.cacheMaxTime;
    }

    public void setCacheMaxTime(int cacheMaxTime) {
        this.cacheMaxTime = cacheMaxTime;
    }

    public void setTable(String name) {
        this.table = name;
    }

    public boolean isDataSource(Class datasourceClass) {
        String name = datasourceClass.getSimpleName();
        return this.isDataSource(name);
    }

    public boolean isDataSource(String datasourceClassName) {
        String currentModeFileName = this.getLogInterface().getClass().getSimpleName();
        return currentModeFileName.equalsIgnoreCase(datasourceClassName);
    }

    public synchronized void add(Map<String, Object> params) {
        if (params == null) {
            return;
        }
        if (params.size() == 0) {
            return;
        }
        List<Map<String, Object>> list = this.cacheMap.get(this.table);
        if (list == null) {
            list = new LinkedList<Map<String, Object>>();
        }
        list.add(params);
        this.cacheMap.put(this.table, list);
        this.checkCommit();
    }

    public int size() {
        return this.cacheMap.get(this.table).size();
    }

    private void checkCommit() {
        this.checkCommit(false);
    }

    private void checkCommit(boolean submit) {
        int currentCacheSize = this.size();
        long currentTime = DateUtil.timeForUnix13();
        if (!submit) {
            if (currentCacheSize > this.cacheMaxNumber - 1) {
                submit = true;
            } else if (this.lastSubmitTime + (long)(this.cacheMaxTime * 1000) < currentTime) {
                submit = true;
            }
        }
        if (submit) {
            System.out.println("log submit " + this.size() + ", table:" + this.table + ", datasource:" + this.getDatasource().getClass().getName());
            this.lastSubmitTime = currentTime;
            boolean submitResult = this.commit();
            if (submitResult) {
                this.cacheMap.put(this.table, new LinkedList());
            }
        }
    }

    public boolean commit() {
        return this.getDatasource().commit(this.table, this.cacheMap.get(this.table));
    }

    public LogListVO list(String query, int everyPageNumber, int currentPage) {
        return this.getLogInterface().list(this.table, query, everyPageNumber, currentPage);
    }
}

