/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.ufile.util;

import cn.ucloud.ufile.annotation.UcloudParam;
import cn.ucloud.ufile.util.Parameter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class ParameterMaker {
    public static <V> List<Parameter<V>> makeParameter(Object bean) throws IllegalAccessException, InvocationTargetException {
        List<Object> tmp;
        Class<?> objectClass;
        ArrayList<Parameter<V>> params = new ArrayList<Parameter<V>>();
        if (bean != null) {
            objectClass = bean.getClass();
            Class<?> superclass = objectClass.getSuperclass();
            tmp = new ArrayList();
            if (superclass != null) {
                tmp = ParameterMaker.getFieldParam(superclass, bean);
                params.addAll(tmp);
            }
            tmp = ParameterMaker.getFieldParam(objectClass, bean);
            params.addAll(tmp);
            if (superclass != null) {
                tmp = ParameterMaker.getMethodParam(superclass, bean);
                params.addAll(tmp);
            }
        } else {
            throw new NullPointerException("params object can not be null");
        }
        tmp = ParameterMaker.getMethodParam(objectClass, bean);
        params.addAll(tmp);
        return params;
    }

    private static <V> List<Parameter<V>> getFieldParam(Class clazz, Object bean) throws IllegalAccessException {
        ArrayList<Parameter<V>> list = new ArrayList<Parameter<V>>();
        if (clazz != null) {
            Field[] declaredFields = clazz.getDeclaredFields();
            int len = clazz.getDeclaredFields().length;
            for (int i = 0; i < len; ++i) {
                UcloudParam annotation = declaredFields[i].getAnnotation(UcloudParam.class);
                if (annotation == null) continue;
                declaredFields[i].setAccessible(true);
                Object value = declaredFields[i].get(bean);
                if (value == null) continue;
                Parameter<Object> param = new Parameter<Object>(annotation.value(), value);
                list.add(param);
            }
        }
        return list;
    }

    private static <V> List<Parameter<V>> getMethodParam(Class clazz, Object bean) throws InvocationTargetException, IllegalAccessException {
        ArrayList<Parameter<V>> list = new ArrayList<Parameter<V>>();
        if (clazz != null) {
            Method[] declaredMethods = clazz.getDeclaredMethods();
            int len = declaredMethods.length;
            for (int i = 0; i < len; ++i) {
                UcloudParam annotation = declaredMethods[i].getAnnotation(UcloudParam.class);
                if (annotation == null) continue;
                declaredMethods[i].setAccessible(true);
                Object invoke = declaredMethods[i].invoke(bean, new Object[0]);
                if (invoke == null || !(invoke instanceof List)) continue;
                List params = (List)invoke;
                list.addAll(params);
            }
        }
        return list;
    }
}

