/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.ufile.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class JLog {
    private static volatile JLog mInstance;
    private boolean isSaveLog = false;
    public static boolean SHOW_TEST;
    public static boolean SHOW_DEBUG;
    public static boolean SHOW_VERBOSE;
    public static boolean SHOW_INFO;
    public static boolean SHOW_WARN;
    public static boolean SHOW_ERROR;
    private static final String LOG_POSITION_FORMAT = "[(%s:%s)#%s]: ";

    private JLog() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static JLog getInstance() {
        if (mInstance != null) return mInstance;
        Class<JLog> clazz = JLog.class;
        synchronized (JLog.class) {
            if (mInstance != null) return mInstance;
            mInstance = new JLog();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public static void init(String basePath, int maxSaveDays, boolean isSaveLog) {
        JLog.getInstance();
        JLog.mInstance.isSaveLog = isSaveLog;
        if (isSaveLog) {
            LogFile.initBasePath(basePath, maxSaveDays);
        }
    }

    private static String getLogPosition() {
        StackTraceElement[] trace = new Throwable().fillInStackTrace().getStackTrace();
        if (trace == null || trace.length < 3) {
            return "<unknown>";
        }
        return String.format(LOG_POSITION_FORMAT, trace[2].getFileName(), trace[2].getLineNumber(), trace[2].getMethodName());
    }

    public static void V(String TAG, String info) {
        if (SHOW_VERBOSE) {
            System.out.println("VERBOSE-> " + TAG + ": " + JLog.getLogPosition() + info);
        }
    }

    public static void D(String TAG, String info) {
        if (SHOW_DEBUG) {
            System.out.println("DEBUG-> " + TAG + ": " + JLog.getLogPosition() + info);
        }
    }

    public static void T(String TAG, String info) {
        if (SHOW_TEST) {
            System.out.println("TEST-> " + TAG + ": " + JLog.getLogPosition() + info);
        }
    }

    public static void I(String TAG, String info) {
        if (SHOW_INFO) {
            System.out.println("INFO-> " + TAG + ": " + info);
        }
    }

    public static void W(String TAG, String info) {
        if (SHOW_WARN) {
            System.out.println("WARN-> " + TAG + ": " + JLog.getLogPosition() + info);
        }
    }

    public static void E(String TAG, String info) {
        if (SHOW_ERROR) {
            System.out.println("ERROR-> " + TAG + ": " + JLog.getLogPosition() + info);
        }
    }

    public static void V(String TAG, String info, Throwable throwable) {
        if (SHOW_VERBOSE) {
            System.out.println("VERBOSE-> " + TAG + ": " + JLog.getLogPosition() + info + "\n" + throwable);
        }
    }

    public static void D(String TAG, String info, Throwable throwable) {
        if (SHOW_DEBUG) {
            System.out.println("DEBUG-> " + TAG + ": " + JLog.getLogPosition() + info + "\n" + throwable);
        }
    }

    public static void T(String TAG, String info, Throwable throwable) {
        if (SHOW_TEST) {
            System.out.println("TEST-> " + TAG + ": " + JLog.getLogPosition() + info + "\n" + throwable);
        }
    }

    public static void I(String TAG, String info, Throwable throwable) {
        if (SHOW_INFO) {
            System.out.println("INFO-> " + TAG + ": " + info + "\n" + throwable);
        }
    }

    public static void W(String TAG, String info, Throwable throwable) {
        if (SHOW_WARN) {
            System.out.println("WARN-> " + TAG + ": " + JLog.getLogPosition() + info + "\n" + throwable);
        }
    }

    public static void E(String TAG, String info, Throwable throwable) {
        if (SHOW_ERROR) {
            System.out.println("ERROR-> " + TAG + ": " + JLog.getLogPosition() + info + "\n" + throwable);
        }
    }

    public static void saveLog(String TAG, String info) {
        if (mInstance != null && JLog.mInstance.isSaveLog) {
            info = JLog.getLogPosition() + " " + info;
            if (SHOW_DEBUG) {
                System.out.println("SAVE-> " + TAG + ": " + info);
            }
            LogFile.writeLog(TAG + ": " + info);
        }
    }

    public static void saveLog(String TAG, String info, Throwable e) {
        if (mInstance != null && JLog.mInstance.isSaveLog) {
            info = JLog.getLogPosition() + " " + info;
            if (e != null) {
                info = info + "\n" + e;
            }
            if (SHOW_ERROR) {
                System.out.println("SAVE-> " + TAG + ": " + info + "\n" + e);
            }
            LogFile.writeLog(TAG + ": " + info);
        }
    }

    static {
        SHOW_TEST = false;
        SHOW_DEBUG = false;
        SHOW_VERBOSE = false;
        SHOW_INFO = true;
        SHOW_WARN = true;
        SHOW_ERROR = true;
    }

    public static class LogFile {
        private static final String TAG = "LogFile";
        private static final String LOG_FILE_SUFFIX = ".log";
        private static String sLogBasePath;
        private static ExecutorService sExecutorService;
        public static final String FORMATTER_DAY = "yy_MM_dd";
        public static final String FORMATTER_SECOND = "yy-MM-dd HH:mm:ss";
        public static SimpleDateFormat sSecondFormat;

        public static void initBasePath(String basePath, int maxSaveDays) {
            sLogBasePath = basePath;
            if (!new File(basePath).exists()) {
                new File(basePath).mkdirs();
            }
            LogFile.delOldFiles(new File(basePath), maxSaveDays);
        }

        public static void delOldFiles(File dir, int days) {
            File[] files;
            int daysMillis = days * 24 * 60 * 60 * 1000;
            if (dir.exists() && (files = dir.listFiles()) != null) {
                for (int i = 0; i < files.length; ++i) {
                    if (!files[i].isFile() || System.currentTimeMillis() - files[i].lastModified() <= (long)daysMillis) continue;
                    files[i].delete();
                }
            }
        }

        public static void write(final File file, final String content, final boolean isOverride) {
            sExecutorService.execute(new Runnable(){

                @Override
                public void run() {
                    FileOutputStream fos = null;
                    try {
                        boolean isExist = file.exists();
                        fos = new FileOutputStream(file, isExist && !isOverride);
                        fos.write(content.getBytes("UTF-8"));
                    }
                    catch (IOException e) {
                        System.out.println("LogFile: " + e);
                    }
                    finally {
                        if (fos != null) {
                            try {
                                fos.close();
                            }
                            catch (IOException e) {
                                System.out.println("LogFile: " + e);
                            }
                        }
                    }
                }
            });
        }

        public static void writeLog(String content) {
            content = content.replaceFirst("]", "] \n");
            LogFile.write(LogFile.getLogFile(), "\n[" + LogFile.getFormattedSecond() + "]" + content + "\n\n", false);
        }

        public static File getLogFile() {
            File logFile;
            File dir = new File(sLogBasePath);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            if (!(logFile = new File(dir, LogFile.getFormattedDay() + LOG_FILE_SUFFIX)).exists()) {
                try {
                    logFile.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return logFile;
        }

        public static String getFormattedDay() {
            return new SimpleDateFormat(FORMATTER_DAY, Locale.CHINA).format(new Date());
        }

        public static String getFormattedSecond() {
            return sSecondFormat.format(new Date());
        }

        static {
            sExecutorService = Executors.newSingleThreadExecutor();
            sSecondFormat = new SimpleDateFormat(FORMATTER_SECOND, Locale.CHINA);
        }
    }
}

