/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.ufile.util;

import java.util.List;
import java.util.Random;

public class HexFormatter {
    public static int BCD2Int(byte data) {
        data = (byte)(data & 0xFF);
        int low = data & 0xF;
        int high = data >> 4 & 0xF;
        int res = high * 10 + low;
        return res;
    }

    public static byte Int2BCD(int data) {
        byte res = (byte)(Integer.parseInt(Integer.toString(data), 16) & 0xFF);
        return res;
    }

    public static String makeHexRandomString(int byteSize) {
        if (byteSize < 1) {
            return "";
        }
        Random random = new Random(System.currentTimeMillis());
        StringBuffer sb = new StringBuffer();
        int times = (int)Math.ceil((float)byteSize / 4.0f);
        for (int i = 0; i < times; ++i) {
            int intRnd = random.nextInt();
            for (int j = 0; j < 4; ++j) {
                sb.append(String.format("%02X", intRnd >> j * 8 & 0xFF));
            }
        }
        String rnd = sb.toString();
        return rnd.substring(0, byteSize * 2);
    }

    public static byte[] formatHexString2ByteArray(String str) {
        if (str == null || str.length() == 0) {
            return null;
        }
        int byteLen = (int)Math.ceil((float)str.length() / 2.0f);
        return HexFormatter.formatHexString2ByteArray(str, byteLen);
    }

    public static byte[] formatHexString2ByteArray(String str, int byteLen) {
        if (str == null || str.length() == 0) {
            return null;
        }
        str = str.trim();
        int dlt = (str = str.replace(" ", "")).length() - byteLen * 2;
        if (dlt > 0) {
            str = str.substring(dlt, str.length());
        } else if (dlt < 0) {
            for (dlt = Math.abs(dlt); dlt > 0; --dlt) {
                str = "0" + str;
            }
        }
        byte[] arr = new byte[byteLen];
        try {
            for (int i = 0; i < byteLen; ++i) {
                arr[i] = (byte)Integer.parseInt(str.substring(i * 2, i * 2 + 2), 16);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return arr;
    }

    public static String formatByteArray2HexString(byte[] data, boolean isUpperCase) {
        if (data == null || data.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (byte b : data) {
            sb.append(String.format("%02x", b));
        }
        return isUpperCase ? sb.toString().toUpperCase() : sb.toString();
    }

    public static String formatByteArray2HexString(List<Byte> data, boolean isUpperCase) {
        if (data == null || data.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (byte b : data) {
            sb.append(String.format("%02x", b));
        }
        return isUpperCase ? sb.toString().toUpperCase() : sb.toString();
    }
}

