/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.ufile.util;

import cn.ucloud.ufile.util.Encoder;
import cn.ucloud.ufile.util.HexFormatter;
import cn.ucloud.ufile.util.JLog;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;

public class FileUtil {
    private static final String TAG = "FileUtil";
    public static final int IO_BUFFER_SIZE = 262144;

    public static File searchFile(File file, String fileName, boolean isDstIsFile) {
        if (file == null || !file.exists() || fileName == null || fileName.length() == 0) {
            return null;
        }
        JLog.T(TAG, "searchFile--->[isFile]:" + file.isFile() + " [isDir]:" + file.isDirectory());
        if (file.getName().equals(fileName) && (isDstIsFile && file.isFile() || !isDstIsFile && file.isDirectory())) {
            return file;
        }
        ArrayList<File> subDirs = new ArrayList<File>();
        File res = null;
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (File f : files) {
                JLog.T(TAG, "searchFile--->for-->[path]:" + f.getAbsolutePath() + " [name]:" + f.getName() + " [isFile]:" + f.isFile() + " [isDir]:" + f.isDirectory());
                if (f.getName().equals(fileName) && (isDstIsFile && f.isFile() || !isDstIsFile && f.isDirectory())) {
                    return f;
                }
                if (!f.isDirectory()) continue;
                subDirs.add(f);
            }
            for (File sd : subDirs) {
                res = FileUtil.searchFile(sd, fileName, isDstIsFile);
                if (res == null) continue;
                return res;
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readSmallFileByteArr(File file) throws IOException {
        if (file == null || !file.exists()) {
            return null;
        }
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        byte[] res = null;
        try {
            fis = new FileInputStream(file);
            bis = new BufferedInputStream(fis);
            byte[] buffer = new byte[262144];
            int len = -1;
            while ((len = bis.read(buffer)) > 0) {
                if (res == null) {
                    res = new byte[len];
                    System.arraycopy(buffer, 0, res, 0, len);
                    continue;
                }
                byte[] tmp = new byte[res.length + len];
                System.arraycopy(res, 0, tmp, 0, res.length);
                System.arraycopy(buffer, 0, tmp, res.length, len);
                res = tmp;
            }
        }
        catch (Throwable throwable) {
            FileUtil.close(bis, fis);
            throw throwable;
        }
        FileUtil.close(bis, fis);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileContent(InputStream is) throws IOException {
        InputStreamReader isr = null;
        BufferedReader br = null;
        StringBuffer res = new StringBuffer();
        try {
            isr = new InputStreamReader(is, Charset.defaultCharset());
            br = new BufferedReader(isr);
            String buffer = null;
            while ((buffer = br.readLine()) != null) {
                res.append(buffer);
            }
        }
        catch (Throwable throwable) {
            FileUtil.close(br, isr, is);
            throw throwable;
        }
        FileUtil.close(br, isr, is);
        return res.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readSmallFileStringContent(File file) throws IOException {
        if (file == null || !file.exists() || !file.isFile()) {
            return null;
        }
        FileReader fr = null;
        BufferedReader br = null;
        StringBuffer res = new StringBuffer();
        try {
            fr = new FileReader(file);
            br = new BufferedReader(fr);
            String buffer = null;
            boolean line = false;
            while ((buffer = br.readLine()) != null) {
                res.append(buffer.trim());
            }
        }
        catch (Throwable throwable) {
            FileUtil.close(br, fr);
            throw throwable;
        }
        FileUtil.close(br, fr);
        return res.toString();
    }

    public static boolean checkFileMD5(File file, String md5) throws IOException {
        if (file == null || !file.exists() || !file.isFile()) {
            return false;
        }
        if (md5 == null || md5.length() == 0) {
            return false;
        }
        String fileMD5 = null;
        try {
            fileMD5 = HexFormatter.formatByteArray2HexString(Encoder.md5(file), true);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return false;
        }
        JLog.T(TAG, "checkFileMD5--->[file]:" + fileMD5 + " [md5]:" + md5);
        return fileMD5 != null && fileMD5.length() > 0 && fileMD5.equals(md5);
    }

    public static void deleteFileCleanly(File file) {
        if (file == null || !file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] files;
            for (File f : files = file.listFiles()) {
                FileUtil.deleteFileCleanly(f);
            }
            file.delete();
        } else {
            boolean res = file.delete();
            JLog.T(TAG, "deleteFileCleanly--->" + file.getAbsolutePath() + " delete=" + res);
        }
    }

    public static void close(AutoCloseable ... closeable) {
        if (closeable == null) {
            return;
        }
        for (AutoCloseable c : closeable) {
            if (c == null) continue;
            try {
                c.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

