/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.ufile.util;

import cn.ucloud.ufile.util.Base64;
import cn.ucloud.ufile.util.FileUtil;
import cn.ucloud.ufile.util.NumberUtil;
import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;

public class Etag {
    private static final String TAG = "Etag";
    @SerializedName(value="PartEtags")
    private List<String> partEtags = new ArrayList<String>();
    @SerializedName(value="ETag")
    private String eTag;

    Etag() {
    }

    public List<String> getPartEtags() {
        return this.partEtags;
    }

    public String geteTag() {
        return this.eTag;
    }

    public String toString() {
        return new Gson().toJson((Object)this);
    }

    public static Etag etag(File file) throws IOException {
        return Etag.etag(file, 0x400000);
    }

    public static Etag etag(InputStream inputStream) throws IOException {
        return Etag.etag(inputStream, 0x400000);
    }

    public static Etag etag(File file, int partSize) throws IOException {
        if (file == null || !file.exists() || !file.isFile()) {
            return null;
        }
        return Etag.etag(new FileInputStream(file), partSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Etag etag(InputStream inputStream, int partSize) throws IOException {
        Etag etag;
        Etag eTag = new Etag();
        if (inputStream == null || partSize <= 0) {
            return null;
        }
        try {
            long size = inputStream.available();
            int blockCount = (int)Math.ceil((double)size * 1.0 / (double)partSize);
            byte[] head = NumberUtil.getBytes(blockCount, ByteOrder.LITTLE_ENDIAN);
            int headSize = head.length;
            byte[] buff = new byte[headSize + 20];
            System.arraycopy(head, 0, buff, 0, headSize);
            byte[] cache = new byte[partSize];
            int readLen = 0;
            byte[] sha1Res = null;
            MessageDigest digest = MessageDigest.getInstance("SHA1");
            if (blockCount > 1) {
                MessageDigest digestSub = MessageDigest.getInstance("SHA1");
                for (int i = 0; i < blockCount && (readLen = inputStream.read(cache)) > 0; ++i) {
                    digestSub.update(cache, 0, readLen);
                    byte[] tmp = digestSub.digest();
                    eTag.partEtags.add(Base64.getUrlEncoder().encodeToString(tmp));
                    digest.update(tmp);
                }
            } else {
                readLen = inputStream.read(cache);
                if (readLen > 0) {
                    digest.update(cache, 0, readLen);
                }
            }
            sha1Res = digest.digest();
            System.arraycopy(sha1Res, 0, buff, 4, sha1Res.length);
            eTag.eTag = Base64.getUrlEncoder().encodeToString(buff);
            etag = eTag;
        }
        catch (NoSuchAlgorithmException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                FileUtil.close(inputStream);
                throw throwable;
            }
            FileUtil.close(inputStream);
            return null;
        }
        FileUtil.close(inputStream);
        return etag;
    }
}

