/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.ufile.util;

import cn.ucloud.ufile.util.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class Encryptor {
    public static final String TYPE_HMAC_SHA1 = "HmacSHA1";
    public static final String TYPE_SHA1 = "SHA1";

    public static byte[] Hmac_SHA1(byte[] key, byte[] data) throws NoSuchAlgorithmException, InvalidKeyException, IllegalStateException {
        if (key == null || key.length == 0) {
            return null;
        }
        if (data == null || data.length == 0) {
            return null;
        }
        byte[] result = null;
        SecretKeySpec secret = new SecretKeySpec(key, TYPE_HMAC_SHA1);
        Mac mac = Mac.getInstance(TYPE_HMAC_SHA1);
        mac.init(secret);
        result = mac.doFinal(data);
        return result;
    }

    public static byte[] Hmac_SHA1(String key, String data) throws UnsupportedEncodingException, InvalidKeyException, NoSuchAlgorithmException, IllegalStateException {
        if (key == null || key.length() == 0) {
            return null;
        }
        if (data == null || data.length() == 0) {
            return null;
        }
        return Encryptor.Hmac_SHA1(key.getBytes("UTF-8"), data.getBytes("UTF-8"));
    }

    public static byte[] SHA1(byte[] data) throws NoSuchAlgorithmException {
        if (data == null || data.length == 0) {
            return null;
        }
        MessageDigest digest = MessageDigest.getInstance(TYPE_SHA1);
        return digest.digest(data);
    }

    public static byte[] SHA1(File file) throws NoSuchAlgorithmException, IOException {
        if (!file.exists() || !file.isFile()) {
            return null;
        }
        Object fis = null;
        return Encryptor.SHA1(new FileInputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] SHA1(InputStream inputStream) throws NoSuchAlgorithmException, IOException {
        if (inputStream == null) {
            return null;
        }
        MessageDigest sha1 = MessageDigest.getInstance(TYPE_SHA1);
        try {
            byte[] buff = new byte[65536];
            int len = 0;
            while ((len = inputStream.read(buff)) > 0) {
                sha1.update(buff, 0, len);
            }
        }
        catch (Throwable throwable) {
            FileUtil.close(inputStream);
            throw throwable;
        }
        FileUtil.close(inputStream);
        return sha1.digest();
    }
}

