/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.ufile.util;

import cn.ucloud.ufile.util.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Encoder {
    public static final String TYPE_MD5 = "MD5";

    public static byte[] md5(byte[] data) throws NoSuchAlgorithmException {
        if (data == null || data.length == 0) {
            return null;
        }
        MessageDigest md5 = MessageDigest.getInstance(TYPE_MD5);
        return md5.digest(data);
    }

    public static byte[] md5(File file) throws NoSuchAlgorithmException, IOException {
        if (!file.exists() || !file.isFile()) {
            return null;
        }
        return Encoder.md5(new FileInputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] md5(InputStream inputStream) throws NoSuchAlgorithmException, IOException {
        if (inputStream == null) {
            return null;
        }
        MessageDigest md5 = MessageDigest.getInstance(TYPE_MD5);
        try {
            byte[] buff = new byte[65536];
            int len = 0;
            while ((len = inputStream.read(buff)) > 0) {
                md5.update(buff, 0, len);
            }
        }
        catch (Throwable throwable) {
            FileUtil.close(inputStream);
            throw throwable;
        }
        FileUtil.close(inputStream);
        return md5.digest();
    }

    public static String urlEncode(String src, String enc) throws UnsupportedEncodingException {
        if (src == null || src.isEmpty()) {
            return "";
        }
        return URLEncoder.encode(src, enc).replace("+", "%20");
    }
}

