/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.ufile.http.request.body;

import cn.ucloud.ufile.http.OnProgressListener;
import cn.ucloud.ufile.http.ProgressConfig;
import cn.ucloud.ufile.util.FileUtil;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicLong;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;
import okio.Source;

public abstract class UploadRequestBody<T>
extends RequestBody {
    public static final int MAX_BUFFER_SIZE = 0x400000;
    public static final int MIN_BUFFER_SIZE = 4096;
    protected T content;
    protected long contentLength = 0L;
    protected MediaType contentType;
    protected OnProgressListener onProgressListener;
    protected ProgressConfig progressConfig;
    protected long bufferSize = 524288L;
    protected AtomicLong bytesWritten;
    protected AtomicLong bytesWrittenCache;
    protected Timer progressTimer;
    protected ProgressTask progressTask;

    public UploadRequestBody() {
    }

    public UploadRequestBody(T content, MediaType contentType, OnProgressListener onProgressListener) {
        this.content = content;
        this.contentType = contentType;
        this.onProgressListener = onProgressListener;
        this.progressConfig = ProgressConfig.callbackDefault();
    }

    public UploadRequestBody<T> setProgressConfig(ProgressConfig progressConfig) {
        this.progressConfig = progressConfig == null ? this.progressConfig : progressConfig;
        return this;
    }

    public abstract UploadRequestBody setContent(T var1);

    public UploadRequestBody setContentType(MediaType contentType) {
        this.contentType = contentType;
        return this;
    }

    public UploadRequestBody setOnProgressListener(OnProgressListener onProgressListener) {
        this.onProgressListener = onProgressListener;
        return this;
    }

    public UploadRequestBody setBufferSize(long bufferSize) {
        this.bufferSize = Math.max(4096L, Math.min(bufferSize, 0x400000L));
        return this;
    }

    public MediaType contentType() {
        return this.contentType;
    }

    public long contentLength() {
        return this.contentLength;
    }

    public UploadRequestBody<T> setContentLength(long contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWriteTo(BufferedSink sink, Source source) throws IOException {
        block22: {
            block23: {
                this.bytesWritten = new AtomicLong(0L);
                this.bytesWrittenCache = new AtomicLong(0L);
                if (this.onProgressListener != null) {
                    switch (this.progressConfig.type) {
                        case PROGRESS_INTERVAL_TIME: {
                            this.progressConfig.interval = Math.max(0L, this.progressConfig.interval);
                            this.progressTimer = new Timer();
                            this.progressTask = new ProgressTask(this.contentLength);
                            this.progressTimer.scheduleAtFixedRate((TimerTask)this.progressTask, this.progressConfig.interval, this.progressConfig.interval);
                            break;
                        }
                        case PROGRESS_INTERVAL_PERCENT: {
                            if (this.progressConfig.interval < 0L || this.progressConfig.interval > 100L) {
                                this.progressConfig.interval = 0L;
                                break;
                            }
                            this.progressConfig.interval = (long)((float)this.progressConfig.interval / 100.0f * (float)this.contentLength);
                            break;
                        }
                        case PROGRESS_INTERVAL_BUFFER: {
                            this.progressConfig.interval = Math.max(0L, Math.min(this.contentLength - 1L, this.progressConfig.interval));
                        }
                    }
                }
                try {
                    long read;
                    while ((read = source.read(sink.buffer(), this.bufferSize)) > 0L) {
                        sink.flush();
                        if (this.onProgressListener == null) continue;
                        long written = this.bytesWritten.addAndGet(read);
                        long cache = this.bytesWrittenCache.addAndGet(read);
                        if (this.progressConfig.type == ProgressConfig.ProgressIntervalType.PROGRESS_INTERVAL_TIME || written < this.contentLength && cache < this.progressConfig.interval) continue;
                        this.bytesWrittenCache.set(0L);
                        this.onProgressListener.onProgress(written, this.contentLength);
                    }
                    if (this.progressConfig.type != ProgressConfig.ProgressIntervalType.PROGRESS_INTERVAL_TIME) break block22;
                    if (this.progressTask == null) break block23;
                }
                catch (Throwable throwable) {
                    if (this.progressConfig.type == ProgressConfig.ProgressIntervalType.PROGRESS_INTERVAL_TIME) {
                        if (this.progressTask != null) {
                            this.progressTask.cancel();
                        }
                        if (this.progressTimer != null) {
                            this.progressTimer.cancel();
                        }
                        if (this.onProgressListener != null) {
                            AtomicLong atomicLong = this.bytesWritten;
                            synchronized (atomicLong) {
                                this.onProgressListener.onProgress(this.bytesWritten.get(), this.contentLength);
                            }
                        }
                    }
                    FileUtil.close(new AutoCloseable[]{source});
                    throw throwable;
                }
                this.progressTask.cancel();
            }
            if (this.progressTimer != null) {
                this.progressTimer.cancel();
            }
            if (this.onProgressListener != null) {
                AtomicLong atomicLong = this.bytesWritten;
                synchronized (atomicLong) {
                    this.onProgressListener.onProgress(this.bytesWritten.get(), this.contentLength);
                }
            }
        }
        FileUtil.close(new AutoCloseable[]{source});
    }

    protected class ProgressTask
    extends TimerTask {
        private long totalSize = 0L;

        protected ProgressTask(long totalSize) {
            this.totalSize = totalSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (UploadRequestBody.this.onProgressListener != null) {
                AtomicLong atomicLong = UploadRequestBody.this.bytesWritten;
                synchronized (atomicLong) {
                    UploadRequestBody.this.onProgressListener.onProgress(UploadRequestBody.this.bytesWritten.get(), this.totalSize);
                }
            }
        }
    }
}

