/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.ufile.http.request;

import cn.ucloud.ufile.http.OnProgressListener;
import cn.ucloud.ufile.http.ProgressConfig;
import cn.ucloud.ufile.http.request.HttpRequestBuilder;
import cn.ucloud.ufile.http.request.body.UploadStreamRequestBody;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;

public class PutStreamRequestBuilder
extends HttpRequestBuilder<InputStream> {
    private OnProgressListener onProgressListener;
    private ProgressConfig progressConfig;
    private UploadStreamRequestBody requestBody;

    public PutStreamRequestBuilder(OnProgressListener onProgressListener) {
        this.onProgressListener = onProgressListener;
        this.requestBody = new UploadStreamRequestBody();
    }

    public PutStreamRequestBuilder setProgressConfig(ProgressConfig progressConfig) {
        this.progressConfig = progressConfig;
        return this;
    }

    public PutStreamRequestBuilder setBufferSize(long bufferSize) {
        this.requestBody.setBufferSize(bufferSize);
        return this;
    }

    @Override
    public Call build(OkHttpClient httpClient) {
        String contentLen = (String)this.header.get("Content-Length");
        this.requestBody.setContent((InputStream)this.params).setContentType(this.mediaType).setContentLength(Long.parseLong(contentLen == null ? "0" : contentLen)).setOnProgressListener(this.onProgressListener).setProgressConfig(this.progressConfig == null ? ProgressConfig.callbackDefault() : this.progressConfig);
        if (this.header == null) {
            this.header = new HashMap();
        }
        this.builder = new Request.Builder().url(this.baseUrl).headers(Headers.of((Map)this.header)).put((RequestBody)this.requestBody);
        return this.customizeOkHttpClient(httpClient).newCall(this.createRequest());
    }
}

