/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.ufile.http.request;

import cn.ucloud.ufile.util.Encoder;
import cn.ucloud.ufile.util.Parameter;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;

public abstract class HttpRequestBuilder<T> {
    protected final String TAG = this.getClass().getSimpleName();
    protected Request.Builder builder;
    protected String baseUrl;
    protected MediaType mediaType;
    protected Object tag;
    protected Map<String, String> header;
    protected T params;
    protected long readTimeOut;
    protected long writeTimeOut;
    protected long connTimeOut;

    public HttpRequestBuilder<T> tag(Object tag) {
        this.tag = tag;
        return this;
    }

    public HttpRequestBuilder<T> baseUrl(String url) {
        this.baseUrl = url;
        return this;
    }

    public HttpRequestBuilder<T> header(Map<String, String> header) {
        this.header = header;
        return this;
    }

    public HttpRequestBuilder<T> mediaType(MediaType mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    public HttpRequestBuilder<T> params(T params) {
        this.params = params;
        return this;
    }

    public HttpRequestBuilder<T> addHeader(String key, String val) {
        if (this.header == null) {
            this.header = new HashMap<String, String>();
        }
        this.header.put(key, val);
        return this;
    }

    public HttpRequestBuilder<T> setReadTimeOut(long readTimeOut) {
        this.readTimeOut = readTimeOut;
        return this;
    }

    public HttpRequestBuilder<T> setWriteTimeOut(long writeTimeOut) {
        this.writeTimeOut = writeTimeOut;
        return this;
    }

    public HttpRequestBuilder<T> setConnTimeOut(long connTimeOut) {
        this.connTimeOut = connTimeOut;
        return this;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public Object getTag() {
        return this.tag;
    }

    public Map<String, String> getHeader() {
        return this.header;
    }

    public T getParams() {
        return this.params;
    }

    public String generateUrlQuery(List<Parameter<String>> query) {
        if (query == null || query.isEmpty()) {
            return "";
        }
        StringBuffer queryBuffer = new StringBuffer();
        for (Parameter<String> param : query) {
            try {
                queryBuffer.append(Encoder.urlEncode(param.key, "UTF-8")).append("=").append(Encoder.urlEncode((String)param.value, "UTF-8")).append("&");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        String queryString = queryBuffer.deleteCharAt(queryBuffer.length() - 1).toString();
        if (queryString == null || queryString.length() == 0) {
            return "";
        }
        return queryBuffer.toString();
    }

    public String generateUrlQuery(Map<String, String> query) {
        if (query == null || query.isEmpty()) {
            return "";
        }
        StringBuffer queryBuffer = new StringBuffer();
        for (String key : query.keySet()) {
            try {
                queryBuffer.append(Encoder.urlEncode(key, "UTF-8")).append("=").append(Encoder.urlEncode(query.get(key), "UTF-8")).append("&");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        String queryString = queryBuffer.deleteCharAt(queryBuffer.length() - 1).toString();
        if (queryString == null || queryString.length() == 0) {
            return "";
        }
        return queryBuffer.toString();
    }

    public String generateGetUrl(String url, Map<String, String> query) {
        String queryStr = this.generateUrlQuery(query);
        queryStr = queryStr == null || queryStr.length() == 0 ? "" : "?" + queryStr;
        return new StringBuffer(url).append(queryStr).toString();
    }

    public String generateGetUrl(String url, List<Parameter<String>> query) {
        String queryStr = this.generateUrlQuery(query);
        queryStr = queryStr == null || queryStr.length() == 0 ? "" : "?" + queryStr;
        return new StringBuffer(url).append(queryStr).toString();
    }

    protected OkHttpClient customizeOkHttpClient(OkHttpClient httpClient) {
        if (httpClient == null) {
            return null;
        }
        if (this.readTimeOut > 0L || this.writeTimeOut > 0L || this.connTimeOut > 0L) {
            this.readTimeOut = this.readTimeOut > 0L ? this.readTimeOut : 30000L;
            this.writeTimeOut = this.writeTimeOut > 0L ? this.writeTimeOut : 30000L;
            this.connTimeOut = this.connTimeOut > 0L ? this.connTimeOut : 10000L;
            return httpClient.newBuilder().readTimeout(this.readTimeOut, TimeUnit.MILLISECONDS).writeTimeout(this.writeTimeOut, TimeUnit.MILLISECONDS).connectTimeout(this.connTimeOut, TimeUnit.MILLISECONDS).build();
        }
        return httpClient;
    }

    protected Request createRequest() {
        if (this.builder != null) {
            this.builder.removeHeader("User-Agent").addHeader("User-Agent", String.format("Ufile-SDK-Java/Ver-%s", "2.6.6"));
        }
        return this.builder.build();
    }

    public abstract Call build(OkHttpClient var1);
}

