/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.ufile.http.interceptor;

import cn.ucloud.ufile.util.JLog;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;

public class LogInterceptor
implements Interceptor {
    private String TAG = this.getClass().getSimpleName();

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        JLog.T(this.TAG, "[request]:" + request.toString());
        JLog.T(this.TAG, "[request-headers]:" + request.headers().toString());
        long startNs = System.nanoTime();
        Response response = chain.proceed(request);
        long tookMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
        JLog.D(this.TAG, "[\u8017\u65f6]:" + tookMs + "ms");
        JLog.T(this.TAG, "[response-code]:" + response.code());
        JLog.T(this.TAG, "[response-headers]:" + response.headers().toString());
        if (JLog.SHOW_TEST) {
            ResponseBody responseBody = response.body();
            BufferedSource source = responseBody.source();
            source.request(Long.MAX_VALUE);
            Buffer buffer = source.buffer();
            if (buffer.size() < 2048L) {
                JLog.T(this.TAG, "[response-body]:" + buffer.clone().readString(Charset.forName("UTF-8")));
            }
        }
        return response;
    }

    private String readRequestBody(Request oriReq) {
        if (oriReq.body() == null) {
            return "";
        }
        Request request = oriReq.newBuilder().build();
        Buffer buffer = new Buffer();
        try {
            request.body().writeTo((BufferedSink)buffer);
            return buffer.readUtf8();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }
}

