/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.ufile.http;

public class ProgressConfig {
    public static final int DEFAULT_PROGRESS_PERIOD = 1000;
    public static final long DEFAULT_PROGRESS_BUFFER_SIZE = 0x100000L;
    public static final int DEFAULT_PROGRESS_PERCENT = 10;
    public ProgressIntervalType type;
    public long interval;

    private ProgressConfig(ProgressIntervalType type) {
        this.type = type;
    }

    public static ProgressConfig callbackDefault() {
        ProgressConfig config = new ProgressConfig(ProgressIntervalType.PROGRESS_INTERVAL_TIME);
        config.interval = 1000L;
        return config;
    }

    public static ProgressConfig callbackWithPeriod(int period) {
        ProgressConfig config = new ProgressConfig(ProgressIntervalType.PROGRESS_INTERVAL_TIME);
        config.interval = period;
        return config;
    }

    public static ProgressConfig callbackWithPercent(int percent) {
        ProgressConfig config = new ProgressConfig(ProgressIntervalType.PROGRESS_INTERVAL_PERCENT);
        config.interval = percent;
        return config;
    }

    public static ProgressConfig callbackWithBuffer(long size) {
        ProgressConfig config = new ProgressConfig(ProgressIntervalType.PROGRESS_INTERVAL_BUFFER);
        config.interval = size;
        return config;
    }

    public static enum ProgressIntervalType {
        PROGRESS_INTERVAL_TIME,
        PROGRESS_INTERVAL_PERCENT,
        PROGRESS_INTERVAL_BUFFER;

    }
}

