/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.ufile.http;

import cn.ucloud.ufile.http.interceptor.LogInterceptor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.Dispatcher;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public class HttpClient {
    protected String TAG = this.getClass().getSimpleName();
    private OkHttpClient mOkHttpClient = null;
    private Config config;

    public HttpClient() {
        this(new Config());
    }

    public HttpClient(Config config) {
        if (config == null) {
            config = new Config();
        }
        this.config = config;
        OkHttpClient.Builder builder = new OkHttpClient.Builder().connectTimeout(config.timeoutConnect, TimeUnit.MILLISECONDS).writeTimeout(config.timeoutWrite, TimeUnit.MILLISECONDS).readTimeout(config.timeoutRead, TimeUnit.MILLISECONDS).connectionPool(new ConnectionPool(config.maxIdleConnections, config.keepAliveDuration, config.keepAliveTimeUnit));
        if (config.interceptors != null) {
            for (Interceptor interceptor : config.interceptors) {
                if (interceptor == null) continue;
                builder.addInterceptor(interceptor);
            }
        }
        if (config.networkInterceptors != null) {
            for (Interceptor interceptor : config.networkInterceptors) {
                if (interceptor == null) continue;
                builder.addNetworkInterceptor(interceptor);
            }
        }
        if (config.executorService != null) {
            builder.dispatcher(new Dispatcher(config.executorService));
        }
        this.mOkHttpClient = builder.build();
    }

    public Config getConfig() {
        return this.config;
    }

    public synchronized void resetHttpClient(Config config) {
        if (config == null) {
            return;
        }
        this.config = config;
        OkHttpClient.Builder builder = this.mOkHttpClient.newBuilder().connectTimeout(config.timeoutConnect, TimeUnit.MILLISECONDS).writeTimeout(config.timeoutWrite, TimeUnit.MILLISECONDS).readTimeout(config.timeoutRead, TimeUnit.MILLISECONDS).connectionPool(new ConnectionPool(config.maxIdleConnections, config.keepAliveDuration, config.keepAliveTimeUnit));
        if (builder.interceptors() != null) {
            builder.interceptors().clear();
        }
        if (config.interceptors != null) {
            for (Interceptor interceptor : config.interceptors) {
                if (interceptor == null) continue;
                builder.addInterceptor(interceptor);
            }
        }
        if (builder.networkInterceptors() != null) {
            builder.networkInterceptors().clear();
        }
        if (config.networkInterceptors != null) {
            for (Interceptor interceptor : config.networkInterceptors) {
                if (interceptor == null) continue;
                builder.addNetworkInterceptor(interceptor);
            }
        }
        if (config.executorService != null) {
            builder.dispatcher(new Dispatcher(config.executorService));
        }
        this.mOkHttpClient = builder.build();
        this.mOkHttpClient = builder.build();
    }

    public synchronized OkHttpClient getOkHttpClient() {
        return this.mOkHttpClient;
    }

    public static class Config {
        public static final long DEFAULT_CONNECT_TIMEOUT = 10000L;
        public static final long DEFAULT_WRITE_TIMEOUT = 30000L;
        public static final long DEFAULT_READ_TIMEOUT = 30000L;
        public static final int DEFAULT_MAX_IDLE_CONNECTIONS = 5;
        public static final long DEFAULT_KEEP_ALIVE_DURATION_MINUTES = 5L;
        public static final TimeUnit DEFAULT_KEEP_ALIVE_DURATION_TIME_UNIT = TimeUnit.MINUTES;
        private long timeoutConnect;
        private long timeoutRead;
        private long timeoutWrite;
        private int maxIdleConnections;
        private long keepAliveDuration;
        private TimeUnit keepAliveTimeUnit;
        private List<Interceptor> interceptors;
        private List<Interceptor> networkInterceptors;
        private ExecutorService executorService;

        public Config() {
            this(5, 5L, DEFAULT_KEEP_ALIVE_DURATION_TIME_UNIT);
        }

        public Config(int maxIdleConnections, long keepAliveDuration, TimeUnit keepAliveTimeUnit) {
            this.maxIdleConnections = maxIdleConnections;
            this.keepAliveDuration = keepAliveDuration;
            this.keepAliveTimeUnit = keepAliveTimeUnit;
            this.timeoutConnect = 10000L;
            this.timeoutRead = 30000L;
            this.timeoutWrite = 30000L;
            this.interceptors = new ArrayList<Interceptor>();
            this.interceptors.add(new LogInterceptor());
        }

        public Config setInterceptors(List<Interceptor> interceptors) {
            this.interceptors = interceptors;
            return this;
        }

        public Config addInterceptor(Interceptor interceptor) {
            if (interceptor == null) {
                return this;
            }
            if (this.interceptors == null) {
                this.interceptors = new ArrayList<Interceptor>();
            }
            this.interceptors.add(interceptor);
            return this;
        }

        public Config setNetworkInterceptors(List<Interceptor> networkInterceptors) {
            this.networkInterceptors = networkInterceptors;
            return this;
        }

        public Config addNetInterceptor(Interceptor interceptor) {
            if (interceptor == null) {
                return this;
            }
            if (this.networkInterceptors == null) {
                this.networkInterceptors = new ArrayList<Interceptor>();
            }
            this.networkInterceptors.add(interceptor);
            return this;
        }

        public Config setMaxIdleConnections(int maxIdleConnections) {
            this.maxIdleConnections = maxIdleConnections;
            return this;
        }

        public Config setKeepAliveDuration(long keepAliveDuration) {
            this.keepAliveDuration = keepAliveDuration;
            return this;
        }

        public Config setKeepAliveTimeUnit(TimeUnit keepAliveTimeUnit) {
            this.keepAliveTimeUnit = keepAliveTimeUnit;
            return this;
        }

        public Config setExecutorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public Config setTimeout(long timeoutConnect, long timeoutRead, long timeoutWrite) {
            this.timeoutConnect = timeoutConnect;
            this.timeoutRead = timeoutRead;
            this.timeoutWrite = timeoutWrite;
            return this;
        }

        public long getTimeoutConnect() {
            return this.timeoutConnect;
        }

        public long getTimeoutRead() {
            return this.timeoutRead;
        }

        public long getTimeoutWrite() {
            return this.timeoutWrite;
        }

        public ExecutorService getExecutorService() {
            return this.executorService;
        }

        public int getMaxIdleConnections() {
            return this.maxIdleConnections;
        }

        public long getKeepAliveDuration() {
            return this.keepAliveDuration;
        }

        public TimeUnit getKeepAliveTimeUnit() {
            return this.keepAliveTimeUnit;
        }

        public List<Interceptor> getInterceptors() {
            return this.interceptors;
        }

        public List<Interceptor> getNetworkInterceptors() {
            return this.networkInterceptors;
        }
    }
}

