/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.ufile.api.object.policy;

import cn.ucloud.ufile.api.object.policy.PolicyParam;
import cn.ucloud.ufile.api.object.policy.PutPolicy;
import cn.ucloud.ufile.exception.UfileClientException;
import cn.ucloud.ufile.util.Base64;
import cn.ucloud.ufile.util.JLog;
import com.google.gson.JsonObject;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public final class PutPolicyForCallback
extends PutPolicy {
    private String policyContent;

    private PutPolicyForCallback(String policyContent, String policy) throws UfileClientException {
        super(policy);
        this.policyContent = policyContent;
        JLog.D("PutPolicy", "[PutPolicyContent]:" + policyContent);
    }

    public String getPolicyContent() {
        return this.policyContent;
    }

    public static class Builder
    extends PutPolicy.Builder<PutPolicyForCallback> {
        private String callbackUrl;
        private String callbackBodyType;
        private List<PolicyParam> callbackBody;

        public Builder(String callbackUrl) {
            this(callbackUrl, new ArrayList<PolicyParam>());
        }

        public Builder(String callbackUrl, List<PolicyParam> callbackBody) {
            this(callbackUrl, callbackBody, null);
        }

        public Builder(String callbackUrl, List<PolicyParam> callbackBody, String callbackBodyType) {
            this.callbackUrl = callbackUrl;
            this.callbackBody = callbackBody;
            this.callbackBodyType = callbackBodyType;
        }

        public Builder setCallbackUrl(String callbackUrl) {
            this.callbackUrl = callbackUrl;
            return this;
        }

        public Builder setCallbackBody(List<PolicyParam> callbackBody) {
            this.callbackBody = callbackBody;
            return this;
        }

        public Builder setCallbackBodyType(String callbackBodyType) {
            this.callbackBodyType = callbackBodyType;
            return this;
        }

        public Builder addCallbackBody(PolicyParam param) {
            if (param == null) {
                return this;
            }
            if (this.callbackBody == null) {
                this.callbackBody = new ArrayList<PolicyParam>();
            }
            this.callbackBody.add(param);
            return this;
        }

        public String getCallbackUrl() {
            return this.callbackUrl;
        }

        public List<PolicyParam> getCallbackBody() {
            return this.callbackBody;
        }

        public String getCallbackBodyType() {
            return this.callbackBodyType;
        }

        @Override
        public PutPolicyForCallback build() throws UfileClientException {
            if (this.callbackUrl == null || this.callbackUrl.isEmpty()) {
                throw new UfileClientException("callbackUrl can not be null or empty in PutPolicyForCallback");
            }
            JsonObject json = new JsonObject();
            json.addProperty("callbackUrl", this.callbackUrl);
            if (this.callbackBodyType != null && !this.callbackBodyType.isEmpty()) {
                json.addProperty("callbackBodyType", this.callbackBodyType);
            }
            StringBuilder sb = new StringBuilder();
            if (this.callbackBody != null) {
                if (this.callbackBodyType != null && this.callbackBodyType.startsWith("application/json")) {
                    JsonObject body = new JsonObject();
                    int len = this.callbackBody.size();
                    for (int i = 0; i < len; ++i) {
                        PolicyParam param = this.callbackBody.get(i);
                        if (param == null || param.key == null) continue;
                        body.addProperty(param.key, (String)param.value);
                    }
                    sb.append(body.toString());
                } else {
                    int i = 0;
                    int len = this.callbackBody.size();
                    while (i < len) {
                        String str;
                        PolicyParam param = this.callbackBody.get(i);
                        if (param != null && (str = param.format()) != null) {
                            sb.append(str);
                        }
                        sb.append(++i < len ? "&" : "");
                    }
                }
            }
            json.addProperty("callbackBody", sb.toString());
            String policy = json.toString();
            return new PutPolicyForCallback(policy, Base64.getUrlEncoder().encodeToString(policy.getBytes(Charset.forName("UTF-8"))));
        }
    }
}

