/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.ufile.api.object;

import cn.ucloud.ufile.api.UfileApi;
import cn.ucloud.ufile.api.object.ObjectConfig;
import cn.ucloud.ufile.auth.ObjectAuthorizer;
import cn.ucloud.ufile.exception.UfileClientException;
import cn.ucloud.ufile.http.HttpClient;
import cn.ucloud.ufile.util.Encoder;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import okhttp3.Response;
import okhttp3.ResponseBody;

public abstract class UfileObjectApi<T>
extends UfileApi<T> {
    protected ObjectAuthorizer authorizer;
    protected ObjectConfig objectConfig;

    public UfileObjectApi(ObjectAuthorizer authorizer, ObjectConfig objectConfig, HttpClient httpClient) {
        super(httpClient, null);
        this.authorizer = authorizer;
        this.objectConfig = objectConfig;
    }

    protected String generateFinalHost(String bucketName, String keyName) throws UfileClientException {
        if (this.objectConfig == null) {
            return null;
        }
        try {
            if (this.objectConfig.isCustomDomain()) {
                keyName = Encoder.urlEncode(keyName, "UTF-8");
                this.host = String.format("%s/%s", this.objectConfig.getCustomHost(), keyName);
            } else {
                bucketName = Encoder.urlEncode(bucketName, "UTF-8");
                String region = Encoder.urlEncode(this.objectConfig.getRegion(), "UTF-8");
                String proxySuffix = Encoder.urlEncode(this.objectConfig.getProxySuffix(), "UTF-8");
                keyName = Encoder.urlEncode(keyName, "UTF-8");
                this.host = this.objectConfig.getProtocol().getValue() + String.format("%s.%s.%s/%s", bucketName, region, proxySuffix, keyName);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new UfileClientException("Occur error during URLEncode bucketName and keyName", e);
        }
        return this.host;
    }

    protected String readResponseBody(Response response) {
        if (response == null) {
            return null;
        }
        ResponseBody body = response.body();
        if (body == null) {
            return null;
        }
        try {
            return body.string();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

