/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.ufile.api.object;

import cn.ucloud.ufile.exception.UfileFileException;
import cn.ucloud.ufile.util.FileUtil;
import cn.ucloud.ufile.util.UfileProtocol;
import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.io.File;
import java.io.IOException;

public class ObjectConfig {
    @SerializedName(value="Region")
    private String region;
    @SerializedName(value="ProxySuffix")
    private String proxySuffix;
    @SerializedName(value="CustomHost")
    private String customHost;
    private UfileProtocol protocol = UfileProtocol.PROTOCOL_HTTPS;

    public ObjectConfig(String region, String proxySuffix) {
        this.region = region;
        this.proxySuffix = proxySuffix;
    }

    public ObjectConfig(String customHost) {
        this.customHost = customHost.startsWith("http") ? customHost : UfileProtocol.PROTOCOL_HTTP.getValue() + customHost;
    }

    public static ObjectConfig loadProfile(File profile) throws UfileFileException {
        if (profile == null) {
            throw new UfileFileException("Profile file is null!");
        }
        if (!profile.exists()) {
            throw new UfileFileException("Profile file is inexistent!");
        }
        if (!profile.isFile()) {
            throw new UfileFileException("Profile is not a file!");
        }
        if (!profile.canRead()) {
            throw new UfileFileException("Profile file is not readable!");
        }
        try {
            String content = FileUtil.readSmallFileStringContent(profile);
            return (ObjectConfig)new Gson().fromJson(content, ObjectConfig.class);
        }
        catch (IOException e) {
            throw new UfileFileException(e);
        }
    }

    public String getRegion() {
        return this.region;
    }

    public ObjectConfig setRegion(String region) {
        this.region = region;
        return this;
    }

    public String getProxySuffix() {
        return this.proxySuffix;
    }

    public ObjectConfig setProxySuffix(String proxySuffix) {
        this.proxySuffix = proxySuffix;
        return this;
    }

    public String getCustomHost() {
        return this.customHost;
    }

    public void setCustomHost(String customHost) {
        this.customHost = customHost;
    }

    public ObjectConfig withProtocol(UfileProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public UfileProtocol getProtocol() {
        return this.protocol;
    }

    public boolean isCustomDomain() {
        return this.customHost != null && this.customHost.length() != 0;
    }

    public static ObjectConfig copy(ObjectConfig src) {
        if (src == null) {
            return null;
        }
        if (src.customHost == null || src.customHost.length() == 0) {
            return new ObjectConfig(src.region, src.proxySuffix);
        }
        return new ObjectConfig(src.customHost);
    }
}

