/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.ufile.api.bucket;

import cn.ucloud.ufile.annotation.UcloudParam;
import cn.ucloud.ufile.api.UfileApi;
import cn.ucloud.ufile.auth.BucketAuthorizer;
import cn.ucloud.ufile.exception.UfileClientException;
import cn.ucloud.ufile.exception.UfileParamException;
import cn.ucloud.ufile.exception.UfileRequiredParamNotFoundException;
import cn.ucloud.ufile.http.HttpClient;
import cn.ucloud.ufile.http.request.GetRequestBuilder;
import cn.ucloud.ufile.util.Parameter;
import cn.ucloud.ufile.util.ParameterMaker;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import okhttp3.MediaType;

public abstract class UfileBucketApi<T>
extends UfileApi<T> {
    protected final String TAG = this.getClass().getSimpleName();
    protected static final String UFILE_BUCKET_API_HOST = "https://api.ucloud.cn";
    @UcloudParam(value="Action")
    protected String action;
    protected BucketAuthorizer authorizer;

    protected UfileBucketApi(BucketAuthorizer authorizer, HttpClient httpClient, String action) {
        super(httpClient, UFILE_BUCKET_API_HOST);
        this.authorizer = authorizer;
        this.action = action;
    }

    @Override
    protected void prepareData() throws UfileClientException {
        try {
            this.parameterValidat();
            this.contentType = "application/json; charset=utf-8";
            List<Parameter<String>> query = ParameterMaker.makeParameter(this);
            query.add(new Parameter<String>("PublicKey", this.authorizer.getPublicKey()));
            String signature = this.authorizer.authorizeBucketUrl(query);
            query.add(new Parameter<String>("Signature", signature));
            this.call = new GetRequestBuilder().setConnTimeOut(this.connTimeOut).setReadTimeOut(this.readTimeOut).setWriteTimeOut(this.writeTimeOut).baseUrl(this.host).addHeader("Content-Type", this.contentType).addHeader("Accpet", "*/*").params(query).mediaType(MediaType.parse((String)"application/json; charset=utf-8")).build(this.httpClient.getOkHttpClient());
        }
        catch (IllegalAccessException e) {
            throw new UfileClientException(e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new UfileClientException(e.getMessage(), e);
        }
    }

    @Override
    protected void parameterValidat() throws UfileParamException {
        if (this.action == null || this.action.isEmpty()) {
            throw new UfileRequiredParamNotFoundException("The required param 'action' can not be null or empty");
        }
    }
}

