/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.ufile.api;

import cn.ucloud.ufile.api.ApiError;
import cn.ucloud.ufile.bean.UfileErrorBean;
import cn.ucloud.ufile.exception.UfileClientException;
import cn.ucloud.ufile.exception.UfileIOException;
import cn.ucloud.ufile.exception.UfileParamException;
import cn.ucloud.ufile.exception.UfileServerException;
import cn.ucloud.ufile.http.BaseHttpCallback;
import cn.ucloud.ufile.http.HttpClient;
import cn.ucloud.ufile.http.UfileHttpException;
import cn.ucloud.ufile.http.response.ResponseParser;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.Locale;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Response;

public abstract class UfileApi<T>
implements Callback,
ResponseParser<T, UfileErrorBean> {
    protected final String TAG = this.getClass().getSimpleName();
    protected String host;
    protected HttpClient httpClient;
    protected Call call;
    protected String contentType = "";
    protected BaseHttpCallback<T, UfileErrorBean> httpCallback;
    protected SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss", Locale.CHINA);
    protected int RESP_CODE_SUCCESS = 200;
    protected JsonElement authOptionalData;
    protected OkHttpClient okHttpClient;
    protected long readTimeOut;
    protected long writeTimeOut;
    protected long connTimeOut;

    protected UfileApi(HttpClient httpClient, String host) {
        this.httpClient = httpClient;
        this.host = host;
        this.okHttpClient = httpClient.getOkHttpClient();
    }

    public void setConnTimeOut(long connTimeOut) {
        this.connTimeOut = connTimeOut;
    }

    public void setReadTimeOut(long readTimeOut) {
        this.readTimeOut = readTimeOut;
    }

    public void setWriteTimeOut(long writeTimeOut) {
        this.writeTimeOut = writeTimeOut;
    }

    public long getConnTimeOut() {
        return this.connTimeOut > 0L ? this.connTimeOut : 10000L;
    }

    public long getReadTimeOut() {
        return this.readTimeOut > 0L ? this.readTimeOut : 30000L;
    }

    public long getWriteTimeOut() {
        return this.writeTimeOut > 0L ? this.writeTimeOut : 30000L;
    }

    protected abstract void prepareData() throws UfileClientException;

    protected abstract void parameterValidat() throws UfileParamException;

    public T execute() throws UfileClientException, UfileServerException {
        this.prepareData();
        try {
            Response response = this.call.execute();
            if (response == null) {
                throw new UfileHttpException("Response is null");
            }
            if (response.code() / 100 != 2) {
                throw new UfileServerException(this.parseErrorResponse(response));
            }
            return this.parseHttpResponse(response);
        }
        catch (IOException e) {
            throw new UfileIOException("Occur IOException while sending http request. The reason may be network timeout, or the file which you want to upload/download is changed or inexistent", e);
        }
    }

    public void executeAsync(final BaseHttpCallback<T, UfileErrorBean> callback) {
        this.httpCallback = callback;
        this.okHttpClient.dispatcher().executorService().submit(new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        UfileApi.this.prepareData();
                        UfileApi.this.call.enqueue((Callback)UfileApi.this);
                    }
                    catch (UfileClientException e) {
                        if (callback == null) break block2;
                        UfileApi.this.httpCallback.onError(null, new ApiError(ApiError.ErrorType.ERROR_PARAMS_ILLEGAL, e), null);
                    }
                }
            }
        });
    }

    public void onFailure(Call call, IOException e) {
        if (this.httpCallback != null) {
            this.httpCallback.onError(call.request(), new ApiError(ApiError.ErrorType.ERROR_NETWORK_ERROR, e), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResponse(Call call, Response response) throws IOException {
        block15: {
            if (response == null) {
                if (this.httpCallback != null) {
                    this.httpCallback.onError(call.request(), new ApiError(ApiError.ErrorType.ERROR_RESPONSE_IS_NULL), null);
                }
                return;
            }
            if (response.code() / 100 != 2) {
                if (this.httpCallback != null) {
                    UfileErrorBean e = null;
                    try {
                        e = this.parseErrorResponse(response);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                    finally {
                        this.httpCallback.onError(call.request(), new ApiError(ApiError.ErrorType.ERROR_SERVER_ERROR, "Response-Code = " + response.code()).setResponseCode(response.code()), e);
                    }
                }
                return;
            }
            try {
                T res = this.parseHttpResponse(response);
                if (res == null) {
                    if (this.httpCallback != null) {
                        this.httpCallback.onError(call.request(), new ApiError(ApiError.ErrorType.ERROR_RESPONSE_SPARSE_FAILED, "The result of parseHttpResponse is null").setResponseCode(response.code()), null);
                    }
                    return;
                }
                if (this.httpCallback != null) {
                    this.httpCallback.onResponse(res);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                if (this.httpCallback == null) break block15;
                this.httpCallback.onError(call.request(), new ApiError(ApiError.ErrorType.ERROR_RESPONSE_SPARSE_FAILED, throwable).setResponseCode(response.code()), null);
            }
        }
    }

    @Override
    public T parseHttpResponse(Response response) throws UfileClientException, UfileServerException {
        try {
            Type type = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
            String content = response.body().string();
            content = content == null || content.length() == 0 ? "{}" : content;
            Object object = new Gson().fromJson(content, type);
            return (T)object;
        }
        catch (IOException e) {
            throw new UfileIOException("Occur IOException while parsing response data", e);
        }
        finally {
            response.body().close();
        }
    }

    @Override
    public UfileErrorBean parseErrorResponse(Response response) throws UfileClientException {
        try {
            String content = response.body().string();
            content = content == null || content.length() == 0 ? "" : content;
            UfileErrorBean errorBean = null;
            try {
                errorBean = (UfileErrorBean)new Gson().fromJson(content, UfileErrorBean.class);
            }
            catch (JsonParseException e) {
                errorBean = new UfileErrorBean();
                errorBean.setErrMsg(content);
            }
            errorBean.setResponseCode(response.code());
            errorBean.setxSessionId(response.header("X-SessionId"));
            UfileErrorBean ufileErrorBean = errorBean;
            return ufileErrorBean;
        }
        catch (IOException e) {
            throw new UfileIOException("Occur IOException while parsing error data", e);
        }
        finally {
            response.body().close();
        }
    }
}

