/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.ufile.api;

public class ApiError {
    private ErrorType type;
    private String message;
    private Throwable throwable;
    private int responseCode = -1;

    public ApiError(ErrorType type) {
        this.type = type;
        this.message = type.name();
    }

    public ApiError(ErrorType type, String message) {
        this.type = type;
        this.message = message;
    }

    public ApiError(ErrorType type, Throwable throwable) {
        this.type = type;
        this.message = throwable.getMessage();
        this.throwable = throwable;
    }

    public ApiError(ErrorType type, String message, Throwable throwable) {
        this.type = type;
        this.message = message;
        this.throwable = throwable;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public ErrorType getType() {
        return this.type;
    }

    public String getMessage() {
        return this.message;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public ApiError setType(ErrorType type) {
        this.type = type;
        return this;
    }

    public ApiError setMessage(String message) {
        this.message = message;
        return this;
    }

    public ApiError setThrowable(Throwable throwable) {
        this.throwable = throwable;
        return this;
    }

    public ApiError setResponseCode(int responseCode) {
        this.responseCode = responseCode;
        return this;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName() + "--->");
        sb.append(String.format(" [type]: %s", new Object[]{this.type}));
        sb.append(String.format(" [message]: %s", this.message));
        sb.append(String.format(" [responseCode]: %s", this.responseCode));
        sb.append(String.format(" [throwable]: %s", this.throwable));
        return sb.toString();
    }

    public static enum ErrorType {
        ERROR_NORMAL_ERROR,
        ERROR_NETWORK_ERROR,
        ERROR_SERVER_ERROR,
        ERROR_RESPONSE_IS_NULL,
        ERROR_RESPONSE_SPARSE_FAILED,
        ERROR_PARAMS_ILLEGAL;

    }
}

