/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.rest.client.enhance.feign;

import cn.herodotus.engine.assistant.core.context.TenantContextHolder;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dromara.hutool.http.server.servlet.JakartaServletUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class FeignRequestInterceptor
implements RequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(FeignRequestInterceptor.class);

    public void apply(RequestTemplate requestTemplate) {
        HttpServletRequest httpServletRequest = this.getHttpServletRequest();
        if (httpServletRequest != null) {
            String string;
            Map headers = JakartaServletUtil.getHeaderMap((HttpServletRequest)httpServletRequest);
            for (Map.Entry entry : headers.entrySet()) {
                Map requestHeaders;
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"Content-Length") || StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"Content-Type") && (requestHeaders = requestTemplate.headers()).containsKey("Content-Type")) continue;
                if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"User-Agent")) {
                    value = StringUtils.replace((String)value, (String)"\n", (String)"");
                    entry.setValue(value);
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"Sec-CH-UA")) {
                    value = StringUtils.replace((String)value, (String)"\n", (String)"");
                    entry.setValue(value);
                }
                requestTemplate.header(key, new String[]{value});
            }
            log.debug("[Herodotus] |- Feign Request Interceptor copy all need transfer header!");
            String tenantIdHeader = "X-Herodotus-Tenant-Id";
            if (!headers.containsKey(tenantIdHeader) && StringUtils.isNotBlank((CharSequence)(string = TenantContextHolder.getTenantId()))) {
                log.info("[Herodotus] |- Feign Request Interceptor Tenant is : {}", (Object)string);
                requestTemplate.header(tenantIdHeader, new String[]{string});
            }
            if (headers.containsKey("X-Request-ID")) {
                String string2 = (String)headers.get("X-Request-ID");
                MDC.put((String)"traceId", (String)string2);
                log.info("[Herodotus] |- Feign Request Interceptor Trace: {}", (Object)string2);
            }
        }
        log.trace("[Herodotus] |- Feign Request Interceptor [{}]", (Object)requestTemplate.toString());
    }

    private HttpServletRequest getHttpServletRequest() {
        try {
            return ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        }
        catch (Exception e) {
            log.error("[Herodotus] |- Feign Request Interceptor can not get Request.");
            return null;
        }
    }
}

