/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.rest.core.definition;

import cn.herodotus.engine.rest.core.utils.WebUtils;
import jakarta.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.dromara.hutool.crypto.SecureUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;

public abstract class AbstractBaseHandlerInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AbstractBaseHandlerInterceptor.class);

    protected String generateRequestKey(HttpServletRequest request) {
        String sessionId = request.getHeader("X-Herodotus-Session");
        if (StringUtils.isBlank((CharSequence)sessionId)) {
            sessionId = WebUtils.getSessionId(request);
        }
        String url = request.getRequestURI();
        String method = request.getMethod();
        if (StringUtils.isNotBlank((CharSequence)sessionId)) {
            String key = SecureUtil.md5((String)(sessionId + ":" + url + ":" + method));
            log.debug("[Herodotus] |- IdempotentInterceptor key is [{}].", (Object)key);
            return key;
        }
        log.warn("[Herodotus] |- IdempotentInterceptor cannot create key, because sessionId is null.");
        return null;
    }
}

