/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.rest.core.controller;

import cn.herodotus.engine.assistant.core.definition.domain.AbstractEntity;
import cn.herodotus.engine.assistant.core.domain.Result;
import cn.herodotus.engine.data.core.service.ReadableService;
import cn.herodotus.engine.rest.core.controller.Controller;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Sort;

public interface ReadableController<E extends AbstractEntity, ID extends Serializable>
extends Controller {
    public ReadableService<E, ID> getReadableService();

    default public Result<Map<String, Object>> findByPage(Integer pageNumber, Integer pageSize) {
        Page pages = this.getReadableService().findByPage(pageNumber.intValue(), pageSize.intValue());
        return this.result(pages);
    }

    default public Result<Map<String, Object>> findByPage(Integer pageNumber, Integer pageSize, Sort.Direction direction, String ... properties) {
        Page pages = this.getReadableService().findByPage(pageNumber.intValue(), pageSize.intValue(), direction, properties);
        return this.result(pages);
    }

    default public Result<List<E>> findAll() {
        List domains = this.getReadableService().findAll();
        return this.result(domains);
    }

    default public Result<E> findById(ID id) {
        AbstractEntity domain = (AbstractEntity)this.getReadableService().findById(id);
        return this.result(domain);
    }
}

