/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.rest.core.controller;

import cn.herodotus.engine.assistant.core.domain.Result;
import cn.herodotus.engine.data.core.entity.BaseMongoEntity;
import cn.herodotus.engine.data.core.service.MongoService;
import cn.herodotus.engine.rest.core.controller.Controller;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Sort;

public interface MongoController<E extends BaseMongoEntity, ID extends Serializable>
extends Controller {
    public MongoService<E, ID> getMongoService();

    default public Result<Map<String, Object>> findByPage(Integer pageNumber, Integer pageSize) {
        Page pages = this.getMongoService().findByPage(pageNumber.intValue(), pageSize.intValue());
        return this.result(pages);
    }

    default public Result<Map<String, Object>> findByPage(Integer pageNumber, Integer pageSize, Sort.Direction direction, String ... properties) {
        Page pages = this.getMongoService().findByPage(pageNumber.intValue(), pageSize.intValue(), direction, properties);
        return this.result(pages);
    }

    default public Result<List<E>> findAll() {
        List domains = this.getMongoService().findAll();
        return this.result(domains);
    }

    default public Result<E> findById(ID id) {
        BaseMongoEntity domain = this.getMongoService().findById(id);
        return this.result(domain);
    }

    default public Result<E> saveOrUpdate(E domain) {
        BaseMongoEntity savedDomain = this.getMongoService().save(domain);
        return this.result(savedDomain);
    }

    default public Result<String> delete(ID id) {
        Result<String> result = this.result(String.valueOf(id));
        this.getMongoService().deleteById(id);
        return result;
    }
}

