/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.rest.core.controller;

import cn.herodotus.engine.assistant.core.definition.domain.AbstractEntity;
import cn.herodotus.engine.assistant.core.domain.Result;
import cn.herodotus.engine.rest.core.annotation.AccessLimited;
import cn.herodotus.engine.rest.core.controller.ReadableController;
import cn.herodotus.engine.rest.core.definition.dto.Pager;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.data.domain.Sort;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;

@SecurityRequirement(name="HERODOTUS_AUTH")
public abstract class BaseReadableRestController<E extends AbstractEntity, ID extends Serializable>
implements ReadableController<E, ID> {
    @AccessLimited
    @Operation(summary="\u5206\u9875\u67e5\u8be2\u6570\u636e", description="\u901a\u8fc7pageNumber\u548cpageSize\u83b7\u53d6\u5206\u9875\u6570\u636e", responses={@ApiResponse(description="\u5355\u4f4d\u5217\u8868", content={@Content(mediaType="application/json", schema=@Schema(implementation=Map.class))}), @ApiResponse(responseCode="204", description="\u67e5\u8be2\u6210\u529f\uff0c\u672a\u67e5\u5230\u6570\u636e"), @ApiResponse(responseCode="500", description="\u67e5\u8be2\u5931\u8d25")})
    @Parameters(value={@Parameter(name="pager", required=true, in=ParameterIn.PATH, description="\u5206\u9875Bo\u5bf9\u8c61", schema=@Schema(implementation=Pager.class))})
    @GetMapping
    public Result<Map<String, Object>> findByPage(@Validated Pager pager) {
        if (ArrayUtils.isNotEmpty((Object[])pager.getProperties())) {
            Sort.Direction direction = Sort.Direction.valueOf((String)pager.getDirection());
            return ReadableController.super.findByPage(pager.getPageNumber(), pager.getPageSize(), direction, pager.getProperties());
        }
        return ReadableController.super.findByPage(pager.getPageNumber(), pager.getPageSize());
    }
}

