/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.rest.core.controller;

import cn.herodotus.engine.assistant.core.domain.Result;
import cn.herodotus.engine.data.core.entity.BaseMongoEntity;
import cn.herodotus.engine.rest.core.annotation.AccessLimited;
import cn.herodotus.engine.rest.core.annotation.Idempotent;
import cn.herodotus.engine.rest.core.controller.MongoController;
import cn.herodotus.engine.rest.core.definition.dto.Pager;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.dromara.hutool.core.data.id.IdUtil;
import org.springframework.data.domain.Sort;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@SecurityRequirement(name="HERODOTUS_AUTH")
public abstract class BaseMongoController<E extends BaseMongoEntity, ID extends Serializable>
implements MongoController<E, ID> {
    @AccessLimited
    @Operation(summary="\u5206\u9875\u67e5\u8be2\u6570\u636e", description="\u901a\u8fc7pageNumber\u548cpageSize\u83b7\u53d6\u5206\u9875\u6570\u636e", responses={@ApiResponse(description="\u5355\u4f4d\u5217\u8868", content={@Content(mediaType="application/json", schema=@Schema(implementation=Map.class))})})
    @Parameters(value={@Parameter(name="pager", required=true, in=ParameterIn.PATH, description="\u5206\u9875Bo\u5bf9\u8c61", schema=@Schema(implementation=Pager.class))})
    @GetMapping
    public Result<Map<String, Object>> findByPage(@Validated Pager pager) {
        if (ArrayUtils.isNotEmpty((Object[])pager.getProperties())) {
            Sort.Direction direction = Sort.Direction.valueOf((String)pager.getDirection());
            return MongoController.super.findByPage(pager.getPageNumber(), pager.getPageSize(), direction, pager.getProperties());
        }
        return MongoController.super.findByPage(pager.getPageNumber(), pager.getPageSize());
    }

    @Override
    @AccessLimited
    @Operation(summary="\u6839\u636eID\u67e5\u8be2\u5143\u7d20", description="\u6839\u636eID\u67e5\u8be2\u5143\u7d20", requestBody=@io.swagger.v3.oas.annotations.parameters.RequestBody(content={@Content(mediaType="application/json")}), responses={@ApiResponse(description="\u64cd\u4f5c\u6d88\u606f", content={@Content(mediaType="application/json")})})
    @Parameters(value={@Parameter(name="id", required=true, in=ParameterIn.PATH, description="\u5b9e\u4f53ID\uff0c@Id\u6ce8\u89e3\u5bf9\u5e94\u7684\u5b9e\u4f53\u5c5e\u6027")})
    @GetMapping(value={"/{id}"})
    public Result<E> findById(@PathVariable ID id) {
        return MongoController.super.findById(id);
    }

    @Override
    @Idempotent
    @Operation(summary="\u4fdd\u5b58\u6216\u66f4\u65b0\u6570\u636e", description="\u63a5\u6536JSON\u6570\u636e\uff0c\u8f6c\u6362\u4e3a\u5b9e\u4f53\uff0c\u8fdb\u884c\u4fdd\u5b58\u6216\u66f4\u65b0", requestBody=@io.swagger.v3.oas.annotations.parameters.RequestBody(content={@Content(mediaType="application/json")}), responses={@ApiResponse(description="\u5df2\u4fdd\u5b58\u6570\u636e", content={@Content(mediaType="application/json")})})
    @Parameters(value={@Parameter(name="domain", required=true, description="\u53ef\u8f6c\u6362\u4e3a\u5b9e\u4f53\u7684json\u6570\u636e")})
    @PostMapping
    public Result<E> saveOrUpdate(@RequestBody E domain) {
        if (StringUtils.isBlank((CharSequence)domain.getId())) {
            domain.setId(IdUtil.objectId());
        }
        return MongoController.super.saveOrUpdate(domain);
    }

    @Override
    @Idempotent
    @Operation(summary="\u5220\u9664\u6570\u636e", description="\u6839\u636e\u5b9e\u4f53ID\u5220\u9664\u6570\u636e\uff0c\u4ee5\u53ca\u76f8\u5173\u8054\u7684\u5173\u8054\u6570\u636e", requestBody=@io.swagger.v3.oas.annotations.parameters.RequestBody(content={@Content(mediaType="application/json")}), responses={@ApiResponse(description="\u64cd\u4f5c\u6d88\u606f", content={@Content(mediaType="application/json")})})
    @Parameters(value={@Parameter(name="id", required=true, in=ParameterIn.PATH, description="\u5b9e\u4f53ID\uff0c@Id\u6ce8\u89e3\u5bf9\u5e94\u7684\u5b9e\u4f53\u5c5e\u6027")})
    @DeleteMapping(value={"/{id}"})
    public Result<String> delete(@PathVariable ID id) {
        return MongoController.super.delete(id);
    }
}

