/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.rest.core.context;

import cn.herodotus.engine.assistant.core.enums.Protocol;
import cn.herodotus.engine.assistant.core.enums.Target;
import cn.herodotus.engine.assistant.core.utils.WellFormedUtils;
import cn.herodotus.engine.rest.core.enums.Architecture;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;

public class ServiceContext {
    private static volatile ServiceContext instance;
    private Architecture architecture = Architecture.DISTRIBUTED;
    private Target dataAccessStrategy = Target.REMOTE;
    private Protocol protocol = Protocol.HTTP;
    private String port;
    private String ip;
    private String address;
    private String url;
    private String applicationName;
    private String uaaServiceName;
    private String upmsServiceName;
    private String gatewayAddress;
    private ApplicationContext applicationContext;

    private ServiceContext() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ServiceContext getInstance() {
        if (!ObjectUtils.isEmpty((Object)instance)) return instance;
        Class<ServiceContext> clazz = ServiceContext.class;
        synchronized (ServiceContext.class) {
            if (!ObjectUtils.isEmpty((Object)instance)) return instance;
            instance = new ServiceContext();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public Architecture getArchitecture() {
        return this.architecture;
    }

    public void setArchitecture(Architecture architecture) {
        this.architecture = architecture;
    }

    public Target getDataAccessStrategy() {
        return this.dataAccessStrategy;
    }

    public void setDataAccessStrategy(Target dataAccessStrategy) {
        this.dataAccessStrategy = dataAccessStrategy;
    }

    public boolean isDistributedArchitecture() {
        return this.getArchitecture() == Architecture.DISTRIBUTED;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getGatewayAddress() {
        return this.gatewayAddress;
    }

    public void setGatewayAddress(String gatewayAddress) {
        this.gatewayAddress = gatewayAddress;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public String getAddress() {
        if (this.isDistributedArchitecture()) {
            this.address = this.getGatewayAddress() + "/" + this.getApplicationName();
        } else if (StringUtils.isNotBlank((CharSequence)this.ip) && StringUtils.isNotBlank((CharSequence)this.port)) {
            this.address = this.ip + ":" + this.port;
        }
        return this.address;
    }

    public String getUrl() {
        String address;
        if (StringUtils.isBlank((CharSequence)this.url) && StringUtils.isNotBlank((CharSequence)(address = this.getAddress()))) {
            return WellFormedUtils.addressToUri((String)address, (Protocol)this.getProtocol(), (boolean)false);
        }
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getUaaServiceName() {
        return this.uaaServiceName;
    }

    public void setUaaServiceName(String uaaServiceName) {
        this.uaaServiceName = uaaServiceName;
    }

    public String getUpmsServiceName() {
        return this.upmsServiceName;
    }

    public void setUpmsServiceName(String upmsServiceName) {
        this.upmsServiceName = upmsServiceName;
    }

    public String getOriginService() {
        return this.getApplicationName() + ":" + this.getPort();
    }

    public void publishEvent(ApplicationEvent applicationEvent) {
        this.getApplicationContext().publishEvent(applicationEvent);
    }
}

