/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.rest.core.context;

import cn.herodotus.engine.assistant.core.context.PropertyFinder;
import cn.herodotus.engine.assistant.core.utils.WellFormedUtils;
import cn.herodotus.engine.rest.core.context.ServiceContext;
import cn.herodotus.engine.rest.core.properties.EndpointProperties;
import cn.herodotus.engine.rest.core.properties.PlatformProperties;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;

public class HerodotusApplicationContext {
    private final PlatformProperties platformProperties;
    private final EndpointProperties endpointProperties;
    private final ServerProperties serverProperties;
    private final ServiceContext serviceContext;
    private final ApplicationContext applicationContext;

    public HerodotusApplicationContext(ApplicationContext applicationContext, PlatformProperties platformProperties, EndpointProperties endpointProperties, ServerProperties serverProperties) {
        this.platformProperties = platformProperties;
        this.endpointProperties = endpointProperties;
        this.serverProperties = serverProperties;
        this.applicationContext = applicationContext;
        this.serviceContext = ServiceContext.getInstance();
        this.initServiceContext();
    }

    public void initServiceContext() {
        this.serviceContext.setArchitecture(this.platformProperties.getArchitecture());
        this.serviceContext.setDataAccessStrategy(this.platformProperties.getDataAccessStrategy());
        this.serviceContext.setGatewayAddress(this.endpointProperties.getGatewayServiceUri());
        this.serviceContext.setPort(String.valueOf(this.getPort()));
        this.serviceContext.setIp(this.getHostAddress());
        this.serviceContext.setApplicationContext(this.applicationContext);
        this.serviceContext.setApplicationName(PropertyFinder.getApplicationName((Environment)this.applicationContext.getEnvironment()));
    }

    private String getHostAddress() {
        String address = WellFormedUtils.getHostAddress();
        if (ObjectUtils.isNotEmpty((Object)this.serverProperties.getAddress())) {
            address = this.serverProperties.getAddress().getHostAddress();
        }
        if (StringUtils.isNotBlank((CharSequence)address)) {
            return address;
        }
        return "localhost";
    }

    private Integer getPort() {
        Integer port = this.serverProperties.getPort();
        if (ObjectUtils.isNotEmpty((Object)port)) {
            return port;
        }
        return 8080;
    }

    public PlatformProperties getPlatformProperties() {
        return this.platformProperties;
    }

    public ServiceContext getServiceContext() {
        return this.serviceContext;
    }
}

