/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.assistant.core.utils;

import cn.herodotus.engine.assistant.core.utils.ResourceUtils;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.owasp.validator.html.AntiSamy;
import org.owasp.validator.html.CleanResults;
import org.owasp.validator.html.Policy;
import org.owasp.validator.html.PolicyException;
import org.owasp.validator.html.ScanException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XssUtils {
    private static final Logger log = LoggerFactory.getLogger(XssUtils.class);
    private static volatile XssUtils INSTANCE;
    private final AntiSamy antiSamy;
    private final String nbsp;
    private final String quot;

    private XssUtils() {
        Policy policy = this.createPolicy();
        this.antiSamy = ObjectUtils.isNotEmpty((Object)policy) ? new AntiSamy(policy) : new AntiSamy();
        this.nbsp = this.cleanHtml("&nbsp;");
        this.quot = this.cleanHtml("\"");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static XssUtils getInstance() {
        if (!ObjectUtils.isEmpty((Object)INSTANCE)) return INSTANCE;
        Class<XssUtils> clazz = XssUtils.class;
        synchronized (XssUtils.class) {
            if (!ObjectUtils.isEmpty((Object)INSTANCE)) return INSTANCE;
            INSTANCE = new XssUtils();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private Policy createPolicy() {
        try {
            URL url = ResourceUtils.getURL("classpath:antisamy/antisamy-anythinggoes.xml");
            return Policy.getInstance((URL)url);
        }
        catch (IOException | PolicyException e) {
            log.warn("[Herodotus] |- Antisamy create policy error! {}", (Object)e.getMessage());
            return null;
        }
    }

    private CleanResults scan(String taintedHtml) throws ScanException, PolicyException {
        return this.antiSamy.scan(taintedHtml);
    }

    private String cleanHtml(String taintedHtml) {
        try {
            CleanResults cleanResults = this.scan(taintedHtml);
            return cleanResults.getCleanHTML();
        }
        catch (PolicyException | ScanException e) {
            log.error("[Herodotus] |- Antisamy scan catch error! {}", (Object)e.getMessage());
            return taintedHtml;
        }
    }

    public static String cleaning(String taintedHTML) {
        String cleanHtml = StringEscapeUtils.unescapeHtml4((String)XssUtils.getInstance().cleanHtml(taintedHTML));
        String temp = cleanHtml.replaceAll(XssUtils.getInstance().nbsp, "");
        temp = temp.replaceAll(XssUtils.getInstance().quot, "\"");
        String result = temp.replaceAll("\n", "");
        log.trace("[Herodotus] |- Antisamy process value from [{}] to [{}]", (Object)taintedHTML, (Object)result);
        return result;
    }
}

