/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.assistant.core.json.jackson2;

import cn.herodotus.engine.assistant.core.json.jackson2.BaseObjectMapperBuilderCustomizer;
import cn.herodotus.engine.assistant.core.json.jackson2.modules.EncapsulationClassJackson2Module;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

public class Jackson2DefaultObjectMapperBuilderCustomizer
implements BaseObjectMapperBuilderCustomizer {
    private static final Logger log = LoggerFactory.getLogger(Jackson2DefaultObjectMapperBuilderCustomizer.class);

    public void customize(Jackson2ObjectMapperBuilder builder) {
        builder.featuresToEnable(new Object[]{SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, JsonParser.Feature.ALLOW_SINGLE_QUOTES, JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS.mappedFeature()});
        builder.featuresToDisable(new Object[]{SerializationFeature.FAIL_ON_EMPTY_BEANS, SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES});
        builder.modulesToInstall(modules -> {
            ArrayList<Module> install = new ArrayList<Module>((Collection<Module>)modules);
            install.add((Module)new EncapsulationClassJackson2Module());
            install.add((Module)new Jdk8Module());
            install.add((Module)new JavaTimeModule());
            builder.modulesToInstall(this.toArray(install));
        });
        builder.findModulesViaServiceLoader(true);
        log.debug("[Herodotus] |- DEFAULT ObjectMapper custom configuration execution is completed.");
    }

    public int getOrder() {
        return 1;
    }
}

