/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.assistant.core.exception;

import cn.herodotus.engine.assistant.core.definition.exception.HerodotusException;
import cn.herodotus.engine.assistant.core.domain.Result;
import cn.herodotus.engine.assistant.core.enums.ResultErrorCodes;
import cn.herodotus.engine.assistant.core.exception.FeedbackFactory;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);
    private static final Map<String, Result<String>> EXCEPTION_DICTIONARY = new HashMap<String, Result<String>>();

    public static Result<String> resolveException(Exception ex, String path) {
        log.trace("[Herodotus] |- Global Exception Handler, Path : [{}], Exception\uff1a", (Object)path, (Object)ex);
        if (ex instanceof HerodotusException) {
            HerodotusException exception = (HerodotusException)((Object)ex);
            Result<String> result = exception.getResult();
            result.path(path);
            log.error("[Herodotus] |- Global Exception Handler, Error is : {}", result);
            return result;
        }
        Result<Object> result = Result.failure();
        String exceptionName = ex.getClass().getSimpleName();
        if (StringUtils.isNotEmpty((CharSequence)exceptionName) && EXCEPTION_DICTIONARY.containsKey(exceptionName)) {
            result = EXCEPTION_DICTIONARY.get(exceptionName);
        } else {
            log.warn("[Herodotus] |- Global Exception Handler,  Can not find the exception name [{}] in dictionary, please do optimize ", (Object)exceptionName);
        }
        result.path(path);
        result.stackTrace(ex.getStackTrace());
        result.detail(ex.getMessage());
        log.error("[Herodotus] |- Global Exception Handler, Error is : {}", result);
        return result;
    }

    static {
        EXCEPTION_DICTIONARY.put("AccessDeniedException", FeedbackFactory.getUnauthorizedResult(ResultErrorCodes.ACCESS_DENIED));
        EXCEPTION_DICTIONARY.put("InsufficientAuthenticationException", FeedbackFactory.getUnauthorizedResult(ResultErrorCodes.ACCESS_DENIED));
        EXCEPTION_DICTIONARY.put("HttpRequestMethodNotSupportedException", FeedbackFactory.getMethodNotAllowedResult(ResultErrorCodes.HTTP_REQUEST_METHOD_NOT_SUPPORTED));
        EXCEPTION_DICTIONARY.put("HttpMediaTypeNotAcceptableException", FeedbackFactory.getUnsupportedMediaTypeResult(ResultErrorCodes.HTTP_MEDIA_TYPE_NOT_ACCEPTABLE));
        EXCEPTION_DICTIONARY.put("IllegalArgumentException", FeedbackFactory.getInternalServerErrorResult(ResultErrorCodes.ILLEGAL_ARGUMENT_EXCEPTION));
        EXCEPTION_DICTIONARY.put("NullPointerException", FeedbackFactory.getInternalServerErrorResult(ResultErrorCodes.NULL_POINTER_EXCEPTION));
        EXCEPTION_DICTIONARY.put("IOException", FeedbackFactory.getInternalServerErrorResult(ResultErrorCodes.IO_EXCEPTION));
        EXCEPTION_DICTIONARY.put("HttpMessageNotReadableException", FeedbackFactory.getInternalServerErrorResult(ResultErrorCodes.HTTP_MESSAGE_NOT_READABLE_EXCEPTION));
        EXCEPTION_DICTIONARY.put("TypeMismatchException", FeedbackFactory.getInternalServerErrorResult(ResultErrorCodes.TYPE_MISMATCH_EXCEPTION));
        EXCEPTION_DICTIONARY.put("MissingServletRequestParameterException", FeedbackFactory.getInternalServerErrorResult(ResultErrorCodes.MISSING_SERVLET_REQUEST_PARAMETER_EXCEPTION));
        EXCEPTION_DICTIONARY.put("ProviderNotFoundException", FeedbackFactory.getServiceUnavailableResult(ResultErrorCodes.PROVIDER_NOT_FOUND));
        EXCEPTION_DICTIONARY.put("CookieTheftException", FeedbackFactory.getServiceUnavailableResult(ResultErrorCodes.COOKIE_THEFT));
        EXCEPTION_DICTIONARY.put("InvalidCookieException", FeedbackFactory.getServiceUnavailableResult(ResultErrorCodes.INVALID_COOKIE));
        EXCEPTION_DICTIONARY.put("BadSqlGrammarException", FeedbackFactory.getInternalServerErrorResult(ResultErrorCodes.BAD_SQL_GRAMMAR));
        EXCEPTION_DICTIONARY.put("DataIntegrityViolationException", FeedbackFactory.getInternalServerErrorResult(ResultErrorCodes.DATA_INTEGRITY_VIOLATION));
        EXCEPTION_DICTIONARY.put("TransactionRollbackException", FeedbackFactory.getInternalServerErrorResult(ResultErrorCodes.TRANSACTION_ROLLBACK));
        EXCEPTION_DICTIONARY.put("BindException", FeedbackFactory.getNotAcceptableResult(ResultErrorCodes.METHOD_ARGUMENT_NOT_VALID));
        EXCEPTION_DICTIONARY.put("MethodArgumentNotValidException", FeedbackFactory.getNotAcceptableResult(ResultErrorCodes.METHOD_ARGUMENT_NOT_VALID));
        EXCEPTION_DICTIONARY.put("RedisPipelineException", FeedbackFactory.getInternalServerErrorResult(ResultErrorCodes.PIPELINE_INVALID_COMMANDS));
    }
}

