/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.assistant.core.exception;

import cn.herodotus.engine.assistant.core.domain.Feedback;
import cn.herodotus.engine.assistant.core.domain.Result;
import cn.herodotus.engine.assistant.core.enums.ResultErrorCodes;

public class FeedbackFactory {
    public static Feedback ok(int code, String message) {
        return new Feedback(code, message, 200);
    }

    public static Feedback noContent(int code, String message) {
        return new Feedback(code, message, 204);
    }

    public static Feedback unauthorized(int code, String message) {
        return new Feedback(code, message, 401);
    }

    public static Feedback forbidden(int code, String message) {
        return new Feedback(code, message, 403);
    }

    public static Feedback methodNotAllowed(int code, String message) {
        return new Feedback(code, message, 405);
    }

    public static Feedback notAcceptable(int code, String message) {
        return new Feedback(code, message, 406);
    }

    public static Feedback preconditionFailed(int code, String message) {
        return new Feedback(code, message, 412);
    }

    public static Feedback unsupportedMediaType(int code, String message) {
        return new Feedback(code, message, 415);
    }

    public static Feedback internalServerError(int code, String message) {
        return new Feedback(code, message, 500);
    }

    public static Feedback notImplemented(int code, String message) {
        return new Feedback(code, message, 501);
    }

    public static Feedback serviceUnavailable(int code, String message) {
        return new Feedback(code, message, 503);
    }

    private static Result<String> getResult(ResultErrorCodes resultErrorCodes, int httpStatus) {
        return Result.failure(resultErrorCodes.getMessage(), resultErrorCodes.getCode(), httpStatus, null);
    }

    public static Result<String> getUnauthorizedResult(ResultErrorCodes resultCode) {
        return FeedbackFactory.getResult(resultCode, 401);
    }

    public static Result<String> getForbiddenResult(ResultErrorCodes resultCode) {
        return FeedbackFactory.getResult(resultCode, 403);
    }

    public static Result<String> getMethodNotAllowedResult(ResultErrorCodes resultCode) {
        return FeedbackFactory.getResult(resultCode, 405);
    }

    public static Result<String> getNotAcceptableResult(ResultErrorCodes resultCode) {
        return FeedbackFactory.getResult(resultCode, 406);
    }

    public static Result<String> getPreconditionFailedResult(ResultErrorCodes resultCode) {
        return FeedbackFactory.getResult(resultCode, 412);
    }

    public static Result<String> getUnsupportedMediaTypeResult(ResultErrorCodes resultCode) {
        return FeedbackFactory.getResult(resultCode, 415);
    }

    public static Result<String> getInternalServerErrorResult(ResultErrorCodes resultCode) {
        return FeedbackFactory.getResult(resultCode, 500);
    }

    public static Result<String> getServiceUnavailableResult(ResultErrorCodes resultCode) {
        return FeedbackFactory.getResult(resultCode, 503);
    }
}

