/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.assistant.core.domain;

import cn.herodotus.engine.assistant.core.domain.Error;
import cn.herodotus.engine.assistant.core.domain.Feedback;
import cn.herodotus.engine.assistant.core.enums.ResultErrorCodes;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.google.common.base.MoreObjects;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

@Schema(title="\u7edf\u4e00\u54cd\u5e94\u8fd4\u56de\u5b9e\u4f53", description="\u6240\u6709Rest\u63a5\u53e3\u7edf\u4e00\u8fd4\u56de\u7684\u5b9e\u4f53\u5b9a\u4e49", example="new Result<T>().ok().message(\"XXX\")")
public class Result<T>
implements Serializable {
    @Schema(title="\u81ea\u5b9a\u4e49\u54cd\u5e94\u7f16\u7801")
    private int code = 0;
    @Schema(title="\u54cd\u5e94\u8fd4\u56de\u4fe1\u606f")
    private String message;
    @Schema(title="\u8bf7\u6c42\u8def\u5f84")
    private String path;
    @Schema(title="\u54cd\u5e94\u8fd4\u56de\u6570\u636e")
    private T data;
    @Schema(title="http\u72b6\u6001\u7801")
    private int status;
    @Schema(title="\u94fe\u8def\u8ffd\u8e2aTraceId")
    private String traceId;
    @Schema(title="\u54cd\u5e94\u65f6\u95f4\u6233", pattern="yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private final Date timestamp = new Date();
    @Schema(title="\u6821\u9a8c\u9519\u8bef\u4fe1\u606f")
    private final Error error = new Error();

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String getPath() {
        return this.path;
    }

    public T getData() {
        return this.data;
    }

    public int getStatus() {
        return this.status;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public Error getError() {
        return this.error;
    }

    public Result<T> code(int code) {
        this.code = code;
        return this;
    }

    public Result<T> message(String message) {
        this.message = message;
        return this;
    }

    public Result<T> data(T data) {
        this.data = data;
        return this;
    }

    public Result<T> path(String path) {
        this.path = path;
        return this;
    }

    public Result<T> type(ResultErrorCodes resultErrorCodes) {
        this.code = resultErrorCodes.getCode();
        this.message = resultErrorCodes.getMessage();
        return this;
    }

    public Result<T> status(int httpStatus) {
        this.status = httpStatus;
        return this;
    }

    public Result<T> traceId(String traceId) {
        this.traceId = traceId;
        return this;
    }

    public Result<T> stackTrace(StackTraceElement[] stackTrace) {
        this.error.setStackTrace(stackTrace);
        return this;
    }

    public Result<T> detail(String detail) {
        this.error.setDetail(detail);
        return this;
    }

    public Result<T> validation(String message, String code, String field) {
        this.error.setMessage(message);
        this.error.setCode(code);
        this.error.setField(field);
        return this;
    }

    private static <T> Result<T> create(String message, String detail, int code, int status, T data, StackTraceElement[] stackTrace) {
        Result<T> result = new Result<T>();
        if (StringUtils.isNotBlank((CharSequence)message)) {
            result.message(message);
        }
        if (StringUtils.isNotBlank((CharSequence)detail)) {
            result.detail(detail);
        }
        result.code(code);
        result.status(status);
        if (ObjectUtils.isNotEmpty(data)) {
            result.data(data);
        }
        if (ArrayUtils.isNotEmpty((Object[])stackTrace)) {
            result.stackTrace(stackTrace);
        }
        return result;
    }

    public static <T> Result<T> success(String message, int code, int status, T data) {
        return Result.create(message, null, code, status, data, null);
    }

    public static <T> Result<T> success(String message, int code, T data) {
        return Result.success(message, code, 200, data);
    }

    public static <T> Result<T> success(ResultErrorCodes resultErrorCodes, T data) {
        return Result.success(resultErrorCodes.getMessage(), resultErrorCodes.getCode(), data);
    }

    public static <T> Result<T> success(Feedback feedback, T data) {
        return Result.success(feedback.getMessage(), feedback.getCode(), feedback.getStatus(), data);
    }

    public static <T> Result<T> success(String message, T data) {
        return Result.success(message, Feedback.OK.getCode(), data);
    }

    public static <T> Result<T> success(String message) {
        return Result.success(message, null);
    }

    public static <T> Result<T> success() {
        return Result.success("\u64cd\u4f5c\u6210\u529f\uff01");
    }

    public static <T> Result<T> content(T data) {
        return Result.success("\u64cd\u4f5c\u6210\u529f\uff01", data);
    }

    public static <T> Result<T> failure(String message, String detail, int code, int status, T data, StackTraceElement[] stackTrace) {
        return Result.create(message, detail, code, status, data, stackTrace);
    }

    public static <T> Result<T> failure(String message, String detail, int code, int status, T data) {
        return Result.failure(message, detail, code, status, data, null);
    }

    public static <T> Result<T> failure(String message, int code, int status, T data) {
        return Result.failure(message, message, code, status, data);
    }

    public static <T> Result<T> failure(String message, String detail, int code, T data) {
        return Result.failure(message, detail, code, 500, data);
    }

    public static <T> Result<T> failure(String message, int code, T data) {
        return Result.failure(message, message, code, data);
    }

    public static <T> Result<T> failure(ResultErrorCodes resultErrorCodes, T data) {
        return Result.failure(resultErrorCodes.getMessage(), resultErrorCodes.getCode(), data);
    }

    public static <T> Result<T> failure(Feedback feedback, T data) {
        return Result.failure(feedback.getMessage(), feedback.getCode(), feedback.getStatus(), data);
    }

    public static <T> Result<T> failure(String message, T data) {
        return Result.failure(message, Feedback.ERROR.getCode(), data);
    }

    public static <T> Result<T> failure(String message) {
        return Result.failure(message, null);
    }

    public static <T> Result<T> failure() {
        return Result.failure("\u64cd\u4f5c\u5931\u8d25\uff01");
    }

    public static <T> Result<T> empty(String message, int code, int status) {
        return Result.create(message, null, code, status, null, null);
    }

    public static <T> Result<T> empty(String message, int code) {
        return Result.empty(message, code, Feedback.NO_CONTENT.getStatus());
    }

    public static <T> Result<T> empty(Feedback feedback) {
        return Result.empty(feedback.getMessage(), feedback.getCode(), feedback.getStatus());
    }

    public static <T> Result<T> empty(ResultErrorCodes resultErrorCodes) {
        return Result.empty(resultErrorCodes.getMessage(), resultErrorCodes.getCode());
    }

    public static <T> Result<T> empty(String message) {
        return Result.empty(message, Feedback.NO_CONTENT.getCode());
    }

    public static <T> Result<T> empty() {
        return Result.empty("\u672a\u67e5\u8be2\u5230\u76f8\u5173\u5185\u5bb9\uff01");
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("code", this.code).add("message", (Object)this.message).add("path", (Object)this.path).add("data", this.data).add("status", this.status).add("timestamp", (Object)this.timestamp).add("error", (Object)this.error).toString();
    }

    public Map<String, Object> toModel() {
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        result.put("code", this.code);
        result.put("message", this.message);
        result.put("path", this.path);
        result.put("data", this.data);
        result.put("status", this.status);
        result.put("timestamp", this.timestamp);
        result.put("error", this.error);
        return result;
    }
}

