/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.assistant.core.domain;

import cn.herodotus.engine.assistant.core.enums.ResultErrorCodes;
import cn.herodotus.engine.assistant.core.exception.FeedbackFactory;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;

public class Feedback {
    public static final Feedback OK = FeedbackFactory.ok(20000, "\u6210\u529f");
    public static final Feedback NO_CONTENT = FeedbackFactory.noContent(20400, "\u65e0\u5185\u5bb9");
    public static final Feedback ERROR = FeedbackFactory.internalServerError(50000, "\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef\uff0c\u65e0\u6cd5\u5b8c\u6210\u8bf7\u6c42");
    private final int code;
    private final String message;
    private final int status;

    public Feedback(ResultErrorCodes resultErrorCodes, int status) {
        this(resultErrorCodes.getCode(), resultErrorCodes.getMessage(), status);
    }

    public Feedback(int code, String message, int status) {
        this.code = code;
        this.message = message;
        this.status = status;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public int getStatus() {
        return this.status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Feedback that = (Feedback)o;
        return this.code == that.code && this.status == that.status;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.code, this.status});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("code", this.code).add("message", (Object)this.message).add("status", this.status).toString();
    }
}

