/*
 * Copyright (c) 2020-2030 ZHENGGENGWEI(码匠君)<herodotus@aliyun.com>
 *
 * Dante Engine licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * <http://www.apache.org/licenses/LICENSE-2.0>
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Dante Engine 采用APACHE LICENSE 2.0开源协议，您在使用过程中，需要注意以下几点：
 *
 * 1.请不要删除和修改根目录下的LICENSE文件。
 * 2.请不要删除和修改 Dante Cloud 源码头部的版权声明。
 * 3.请保留源码和相关描述文件的项目出处，作者声明等。
 * 4.分发源码时候，请注明软件出处 <https://gitee.com/herodotus/dante-engine>
 * 5.在修改包名，模块名称，项目代码等时，请注明软件出处 <https://gitee.com/herodotus/dante-engine>
 * 6.若您的项目无法满足以上几点，可申请商业授权
 */

package cn.herodotus.engine.assistant.core.definition.constants;

/**
 * @author gengwei.zheng
 */
public interface SymbolConstants {

    String AMPERSAND = "&";

    String AMPERSAND_ENCODED = "&amp;";

    String APOSTROPHE = "'";

    String APOSTROPHE_AND_COMMA = "',";

    String APOSTROPHE_AND_COMMA_AND_APOSTROPHE = "','";

    String AT = "@";

    String BACK_SLASH = "\\";

    String BETWEEN = "BETWEEN";

    String BLANK = "";

    String CDATA_OPEN = "<![CDATA[";

    String CDATA_CLOSE = "]]>";

    String CLOSE_BRACKET = "]";

    String CLOSE_CURLY_BRACE = "}";

    String CLOSE_PARENTHESIS = ")";

    String COLON = ":";

    String COMMA = ",";

    String COMMA_AND_APOSTROPHE = ",'";

    String COMMA_AND_SPACE = ", ";

    String DASH = "-";

    String DOUBLE_APOSTROPHE = "''";

    String DOUBLE_CLOSE_BRACKET = "]]";

    String DOUBLE_OPEN_BRACKET = "[[";

    String DOUBLE_SLASH = "//";

    String EQUAL = "=";

    String GREATER_THAN = ">";

    String GREATER_THAN_OR_EQUAL = ">=";

    String FORWARD_SLASH = "/";

    String FOUR_SPACES = "    ";

    String FINISH_LEFT_ANGLE = "</";

    String FINISH_RIGHT_ANGLE = "/>";

    String GBK = "GBK";

    String IS_NOT_NULL = "IS NOT NULL";

    String IS_NULL = "IS NULL";

    String IN = "IN";

    String LEFT_ANGLE = "<";

    String LESS_THAN = "<";

    String LESS_THAN_OR_EQUAL = "<=";

    String LIKE = "LIKE";

    String MINUS = "-";

    String NBSP = "&nbsp;";

    String NEW_LINE = "\n";

    String NOT_EQUAL = "!=";

    String DB_NOT_EQUAL = "<>";

    String NOT_LIKE = "NOT LIKE";

    String NULL = "null";

    String OPEN_BRACKET = "[";

    String OPEN_CURLY_BRACE = "{";

    String OPEN_PARENTHESIS = "(";

    String PERCENT = "%";

    String PERIOD = ".";

    String PIPE = "|";

    String PLUS = "+";

    String POUND = "#";

    String QUESTION = "?";

    String QUOTE = "\"";

    String RETURN = "\r";

    String RETURN_NEW_LINE = "\r\n";

    String RIGHT_ANGLE = ">";

    String SEMICOLON = ";";

    String SLASH = FORWARD_SLASH;

    String SPACE = " ";

    String STAR = "*";

    String TAB = "\t";

    String TILDE = "~";

    String UNDERLINE = "_";

    String SUFFIX_EXCEL_2003 = ".xls";

    String SUFFIX_EXCEL_2007 = ".xlsx";

    String SUFFIX_JPEG = ".jpg";

    String SUFFIX_XML = ".xml";

    String SUFFIX_PDF = ".pdf";

    String SUFFIX_ZIP = ".zip";

    String SUFFIX_DOC = ".doc";

    String SUFFIX_DOCX = ".docx";

    String SUFFIX_PPT = ".ppt";

    String SUFFIX_PPTX = ".pptx";

    String SUFFIX_EXCEL = ".xls";

    String SUFFIX_EXCELX = ".xlsx";

    String SUFFIX_SWF = ".swf";

    String SUFFIX_PROPERTIES = ".properties";

    String SUFFIX_YML = ".yml";

    String SUFFIX_YAML = ".yaml";

    String SUFFIX_JSON = ".json";

    String XML_DECLARATION = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
}
