/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.sso;

import cn.dev33.satoken.config.SaSsoConfig;
import cn.dev33.satoken.context.SaHolder;
import cn.dev33.satoken.context.model.SaRequest;
import cn.dev33.satoken.context.model.SaResponse;
import cn.dev33.satoken.sso.SaSsoManager;
import cn.dev33.satoken.sso.SaSsoTemplate;
import cn.dev33.satoken.sso.SaSsoUtil;
import cn.dev33.satoken.sso.exception.SaSsoException;
import cn.dev33.satoken.sso.name.ApiName;
import cn.dev33.satoken.sso.name.ParamName;
import cn.dev33.satoken.stp.StpLogic;
import cn.dev33.satoken.util.SaFoxUtil;
import cn.dev33.satoken.util.SaResult;

public class SaSsoProcessor {
    public SaSsoTemplate ssoTemplate = SaSsoUtil.ssoTemplate;
    public static SaSsoProcessor instance = new SaSsoProcessor();

    public Object serverDister() {
        SaRequest req = SaHolder.getRequest();
        SaSsoConfig cfg = SaSsoManager.getConfig();
        ApiName apiName = this.ssoTemplate.apiName;
        if (req.isPath(apiName.ssoAuth)) {
            return this.ssoAuth();
        }
        if (req.isPath(apiName.ssoDoLogin)) {
            return this.ssoDoLogin();
        }
        if (req.isPath(apiName.ssoCheckTicket) && cfg.getIsHttp().booleanValue()) {
            return this.ssoCheckTicket();
        }
        if (req.isPath(apiName.ssoSignout)) {
            return this.ssoSignout();
        }
        return "{\"msg\": \"not handle\"}";
    }

    public Object ssoAuth() {
        SaRequest req = SaHolder.getRequest();
        SaResponse res = SaHolder.getResponse();
        SaSsoConfig cfg = SaSsoManager.getConfig();
        StpLogic stpLogic = this.ssoTemplate.getStpLogic();
        ParamName paramName = this.ssoTemplate.paramName;
        if (!stpLogic.isLogin()) {
            return cfg.getNotLoginView().get();
        }
        String mode = req.getParam(paramName.mode, "");
        if (mode.equals("simple")) {
            String redirect = req.getParam(paramName.redirect);
            this.ssoTemplate.checkRedirectUrl(redirect);
            return res.redirect(redirect);
        }
        String redirectUrl = this.ssoTemplate.buildRedirectUrl(stpLogic.getLoginId(), req.getParam(paramName.client), req.getParam(paramName.redirect));
        return res.redirect(redirectUrl);
    }

    public Object ssoDoLogin() {
        SaRequest req = SaHolder.getRequest();
        SaSsoConfig cfg = SaSsoManager.getConfig();
        ParamName paramName = this.ssoTemplate.paramName;
        return cfg.getDoLoginHandle().apply(req.getParam(paramName.name), req.getParam(paramName.pwd));
    }

    public Object ssoCheckTicket() {
        ParamName paramName = this.ssoTemplate.paramName;
        SaRequest req = SaHolder.getRequest();
        String client = req.getParam(paramName.client);
        String ticket = req.getParamNotNull(paramName.ticket);
        String sloCallback = req.getParam(paramName.ssoLogoutCall);
        Object loginId = this.ssoTemplate.checkTicket(ticket, client);
        this.ssoTemplate.registerSloCallbackUrl(loginId, sloCallback);
        if (SaFoxUtil.isEmpty((Object)loginId)) {
            return SaResult.error((String)("\u65e0\u6548ticket\uff1a" + ticket));
        }
        return SaResult.data((Object)loginId);
    }

    public Object ssoSignout() {
        SaRequest req = SaHolder.getRequest();
        SaSsoConfig cfg = SaSsoManager.getConfig();
        ParamName paramName = this.ssoTemplate.paramName;
        if (cfg.getIsSlo().booleanValue() && !req.hasParam(paramName.loginId)) {
            return this.ssoSignoutByUserVisit();
        }
        if (cfg.getIsHttp().booleanValue() && cfg.getIsSlo().booleanValue() && req.hasParam(paramName.loginId)) {
            return this.ssoSignoutByClientHttp();
        }
        return "{\"msg\": \"not handle\"}";
    }

    public Object ssoSignoutByUserVisit() {
        SaRequest req = SaHolder.getRequest();
        SaResponse res = SaHolder.getResponse();
        Object loginId = this.ssoTemplate.getStpLogic().getLoginIdDefaultNull();
        if (SaFoxUtil.isNotEmpty((Object)loginId)) {
            this.ssoTemplate.ssoLogout(loginId);
        }
        return this.ssoLogoutBack(req, res);
    }

    public Object ssoSignoutByClientHttp() {
        ParamName paramName = this.ssoTemplate.paramName;
        SaRequest req = SaHolder.getRequest();
        String loginId = req.getParam(paramName.loginId);
        this.ssoTemplate.checkSign(req);
        this.ssoTemplate.ssoLogout(loginId);
        return SaResult.ok();
    }

    public Object clientDister() {
        ApiName apiName = this.ssoTemplate.apiName;
        SaRequest req = SaHolder.getRequest();
        SaSsoConfig cfg = SaSsoManager.getConfig();
        if (req.isPath(apiName.ssoLogin)) {
            return this.ssoLogin();
        }
        if (req.isPath(apiName.ssoLogout)) {
            return this.ssoLogout();
        }
        if (req.isPath(apiName.ssoLogoutCall) && cfg.getIsSlo().booleanValue() && cfg.getIsHttp().booleanValue()) {
            return this.ssoLogoutCall();
        }
        return "{\"msg\": \"not handle\"}";
    }

    public Object ssoLogin() {
        SaRequest req = SaHolder.getRequest();
        SaResponse res = SaHolder.getResponse();
        SaSsoConfig cfg = SaSsoManager.getConfig();
        StpLogic stpLogic = this.ssoTemplate.getStpLogic();
        ApiName apiName = this.ssoTemplate.apiName;
        ParamName paramName = this.ssoTemplate.paramName;
        String back = req.getParam(paramName.back, "/");
        String ticket = req.getParam(paramName.ticket);
        if (stpLogic.isLogin()) {
            return res.redirect(back);
        }
        if (ticket == null) {
            String serverAuthUrl = this.ssoTemplate.buildServerAuthUrl(SaHolder.getRequest().getUrl(), back);
            return res.redirect(serverAuthUrl);
        }
        Object loginId = this.checkTicket(ticket, apiName.ssoLogin);
        if (cfg.getTicketResultHandle() != null) {
            return cfg.getTicketResultHandle().apply(loginId, back);
        }
        if (SaFoxUtil.isEmpty((Object)loginId)) {
            throw new SaSsoException("\u65e0\u6548ticket\uff1a" + ticket).setCode(30004);
        }
        stpLogic.login(loginId);
        return res.redirect(back);
    }

    public Object ssoLogout() {
        SaSsoConfig cfg = SaSsoManager.getConfig();
        if (cfg.getIsSlo().booleanValue() && !cfg.getIsHttp().booleanValue()) {
            return this.ssoLogoutType2();
        }
        if (cfg.getIsSlo().booleanValue() && cfg.getIsHttp().booleanValue()) {
            return this.ssoLogoutType3();
        }
        return "{\"msg\": \"not handle\"}";
    }

    public Object ssoLogoutType2() {
        SaRequest req = SaHolder.getRequest();
        SaResponse res = SaHolder.getResponse();
        StpLogic stpLogic = this.ssoTemplate.getStpLogic();
        if (stpLogic.isLogin()) {
            stpLogic.logout(stpLogic.getLoginId());
        }
        return this.ssoLogoutBack(req, res);
    }

    public Object ssoLogoutType3() {
        SaRequest req = SaHolder.getRequest();
        SaResponse res = SaHolder.getResponse();
        StpLogic stpLogic = this.ssoTemplate.getStpLogic();
        if (!stpLogic.isLogin()) {
            return this.ssoLogoutBack(req, res);
        }
        String url = this.ssoTemplate.buildSloUrl(stpLogic.getLoginId());
        SaResult result = this.ssoTemplate.request(url);
        if (200 == result.getCode()) {
            if (stpLogic.isLogin()) {
                stpLogic.logout();
            }
            return this.ssoLogoutBack(req, res);
        }
        throw new SaSsoException(result.getMsg()).setCode(30006);
    }

    public Object ssoLogoutCall() {
        ParamName paramName = this.ssoTemplate.paramName;
        SaRequest req = SaHolder.getRequest();
        StpLogic stpLogic = this.ssoTemplate.getStpLogic();
        String loginId = req.getParamNotNull(paramName.loginId);
        this.ssoTemplate.checkSign(req);
        stpLogic.logout((Object)loginId);
        return SaResult.ok((String)"\u5355\u70b9\u6ce8\u9500\u56de\u8c03\u6210\u529f");
    }

    public Object ssoLogoutBack(SaRequest req, SaResponse res) {
        ParamName paramName = this.ssoTemplate.paramName;
        String back = req.getParam(paramName.back);
        if (SaFoxUtil.isNotEmpty((Object)back)) {
            if (back.equals("self")) {
                return "<script>if(document.referrer != location.href){ location.replace(document.referrer || '/'); }</script>";
            }
            return res.redirect(back);
        }
        return SaResult.ok((String)"\u5355\u70b9\u6ce8\u9500\u6210\u529f");
    }

    public Object checkTicket(String ticket, String currUri) {
        SaSsoConfig cfg = SaSsoManager.getConfig();
        ApiName apiName = this.ssoTemplate.apiName;
        if (cfg.getIsHttp().booleanValue()) {
            String checkUrl;
            SaResult result;
            String ssoLogoutCall = null;
            if (cfg.getIsSlo().booleanValue()) {
                if (SaFoxUtil.isNotEmpty((Object)cfg.getSsoLogoutCall())) {
                    ssoLogoutCall = cfg.getSsoLogoutCall();
                } else if (SaFoxUtil.isNotEmpty((Object)currUri)) {
                    ssoLogoutCall = SaHolder.getRequest().getUrl().replace(currUri, apiName.ssoLogoutCall);
                }
            }
            if ((result = this.ssoTemplate.request(checkUrl = this.ssoTemplate.buildCheckTicketUrl(ticket, ssoLogoutCall))).getCode() == 200) {
                return result.getData();
            }
            throw new SaSsoException(result.getMsg()).setCode(30005);
        }
        return this.ssoTemplate.checkTicket(ticket);
    }
}

