/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v231.group.VXU_V04_IN1IN2IN3;
import ca.uhn.hl7v2.model.v231.group.VXU_V04_ORCRXARXROBXNTE;
import ca.uhn.hl7v2.model.v231.group.VXU_V04_PV1PV2;
import ca.uhn.hl7v2.model.v231.segment.MSH;
import ca.uhn.hl7v2.model.v231.segment.NK1;
import ca.uhn.hl7v2.model.v231.segment.PD1;
import ca.uhn.hl7v2.model.v231.segment.PID;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class VXU_V04
extends AbstractMessage {
    public VXU_V04(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    public VXU_V04() {
        super((ModelClassFactory)new DefaultModelClassFactory());
        this.init((ModelClassFactory)new DefaultModelClassFactory());
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(PID.class, true, false);
            this.add(PD1.class, false, false);
            this.add(NK1.class, false, true);
            this.add(VXU_V04_PV1PV2.class, false, false);
            this.add(VXU_V04_IN1IN2IN3.class, false, true);
            this.add(VXU_V04_ORCRXARXROBXNTE.class, false, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating VXU_V04 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3.1";
    }

    public MSH getMSH() {
        MSH ret = null;
        try {
            ret = (MSH)this.get("MSH");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PID getPID() {
        PID ret = null;
        try {
            ret = (PID)this.get("PID");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PD1 getPD1() {
        PD1 ret = null;
        try {
            ret = (PD1)this.get("PD1");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NK1 getNK1() {
        NK1 ret = null;
        try {
            ret = (NK1)this.get("NK1");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NK1 getNK1(int rep) {
        NK1 ret = null;
        try {
            ret = (NK1)this.get("NK1", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getNK1Reps() {
        int reps = -1;
        try {
            reps = this.getAll("NK1").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertNK1(NK1 structure, int rep) throws HL7Exception {
        super.insertRepetition("NK1", (Structure)structure, rep);
    }

    public NK1 insertNK1(int rep) throws HL7Exception {
        return (NK1)super.insertRepetition("NK1", rep);
    }

    public NK1 removeNK1(int rep) throws HL7Exception {
        return (NK1)super.removeRepetition("NK1", rep);
    }

    public VXU_V04_PV1PV2 getPV1PV2() {
        VXU_V04_PV1PV2 ret = null;
        try {
            ret = (VXU_V04_PV1PV2)this.get("PV1PV2");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public VXU_V04_IN1IN2IN3 getIN1IN2IN3() {
        VXU_V04_IN1IN2IN3 ret = null;
        try {
            ret = (VXU_V04_IN1IN2IN3)this.get("IN1IN2IN3");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public VXU_V04_IN1IN2IN3 getIN1IN2IN3(int rep) {
        VXU_V04_IN1IN2IN3 ret = null;
        try {
            ret = (VXU_V04_IN1IN2IN3)this.get("IN1IN2IN3", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getIN1IN2IN3Reps() {
        int reps = -1;
        try {
            reps = this.getAll("IN1IN2IN3").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertIN1IN2IN3(VXU_V04_IN1IN2IN3 structure, int rep) throws HL7Exception {
        super.insertRepetition("IN1IN2IN3", (Structure)structure, rep);
    }

    public VXU_V04_IN1IN2IN3 insertIN1IN2IN3(int rep) throws HL7Exception {
        return (VXU_V04_IN1IN2IN3)super.insertRepetition("IN1IN2IN3", rep);
    }

    public VXU_V04_IN1IN2IN3 removeIN1IN2IN3(int rep) throws HL7Exception {
        return (VXU_V04_IN1IN2IN3)super.removeRepetition("IN1IN2IN3", rep);
    }

    public VXU_V04_ORCRXARXROBXNTE getORCRXARXROBXNTE() {
        VXU_V04_ORCRXARXROBXNTE ret = null;
        try {
            ret = (VXU_V04_ORCRXARXROBXNTE)this.get("ORCRXARXROBXNTE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public VXU_V04_ORCRXARXROBXNTE getORCRXARXROBXNTE(int rep) {
        VXU_V04_ORCRXARXROBXNTE ret = null;
        try {
            ret = (VXU_V04_ORCRXARXROBXNTE)this.get("ORCRXARXROBXNTE", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getORCRXARXROBXNTEReps() {
        int reps = -1;
        try {
            reps = this.getAll("ORCRXARXROBXNTE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertORCRXARXROBXNTE(VXU_V04_ORCRXARXROBXNTE structure, int rep) throws HL7Exception {
        super.insertRepetition("ORCRXARXROBXNTE", (Structure)structure, rep);
    }

    public VXU_V04_ORCRXARXROBXNTE insertORCRXARXROBXNTE(int rep) throws HL7Exception {
        return (VXU_V04_ORCRXARXROBXNTE)super.insertRepetition("ORCRXARXROBXNTE", rep);
    }

    public VXU_V04_ORCRXARXROBXNTE removeORCRXARXROBXNTE(int rep) throws HL7Exception {
        return (VXU_V04_ORCRXARXROBXNTE)super.removeRepetition("ORCRXARXROBXNTE", rep);
    }
}

