/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v231.group.CSU_C09_CSPCSSORCOBROBXORCRXARXR;
import ca.uhn.hl7v2.model.v231.group.CSU_C09_PV1PV2;
import ca.uhn.hl7v2.model.v231.segment.CSR;
import ca.uhn.hl7v2.model.v231.segment.NTE;
import ca.uhn.hl7v2.model.v231.segment.PD1;
import ca.uhn.hl7v2.model.v231.segment.PID;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class CSU_C09_PIDPD1NTEPV1PV2CSRCSPCSSORCOBROBXORCRXARXR
extends AbstractGroup {
    public CSU_C09_PIDPD1NTEPV1PV2CSRCSPCSSORCOBROBXORCRXARXR(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PID.class, true, false);
            this.add(PD1.class, false, false);
            this.add(NTE.class, false, true);
            this.add(CSU_C09_PV1PV2.class, false, false);
            this.add(CSR.class, true, false);
            this.add(CSU_C09_CSPCSSORCOBROBXORCRXARXR.class, true, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating CSU_C09_PIDPD1NTEPV1PV2CSRCSPCSSORCOBROBXORCRXARXR - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3.1";
    }

    public PID getPID() {
        PID ret = null;
        try {
            ret = (PID)this.get("PID");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PD1 getPD1() {
        PD1 ret = null;
        try {
            ret = (PD1)this.get("PD1");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE() {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE(int rep) {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getNTEReps() {
        int reps = -1;
        try {
            reps = this.getAll("NTE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public CSU_C09_PV1PV2 getPV1PV2() {
        CSU_C09_PV1PV2 ret = null;
        try {
            ret = (CSU_C09_PV1PV2)this.get("PV1PV2");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public CSR getCSR() {
        CSR ret = null;
        try {
            ret = (CSR)this.get("CSR");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public CSU_C09_CSPCSSORCOBROBXORCRXARXR getCSPCSSORCOBROBXORCRXARXR() {
        CSU_C09_CSPCSSORCOBROBXORCRXARXR ret = null;
        try {
            ret = (CSU_C09_CSPCSSORCOBROBXORCRXARXR)this.get("CSPCSSORCOBROBXORCRXARXR");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public CSU_C09_CSPCSSORCOBROBXORCRXARXR getCSPCSSORCOBROBXORCRXARXR(int rep) {
        CSU_C09_CSPCSSORCOBROBXORCRXARXR ret = null;
        try {
            ret = (CSU_C09_CSPCSSORCOBROBXORCRXARXR)this.get("CSPCSSORCOBROBXORCRXARXR", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getCSPCSSORCOBROBXORCRXARXRReps() {
        int reps = -1;
        try {
            reps = this.getAll("CSPCSSORCOBROBXORCRXARXR").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertCSPCSSORCOBROBXORCRXARXR(CSU_C09_CSPCSSORCOBROBXORCRXARXR structure, int rep) throws HL7Exception {
        super.insertRepetition("CSPCSSORCOBROBXORCRXARXR", (Structure)structure, rep);
    }

    public CSU_C09_CSPCSSORCOBROBXORCRXARXR insertCSPCSSORCOBROBXORCRXARXR(int rep) throws HL7Exception {
        return (CSU_C09_CSPCSSORCOBROBXORCRXARXR)super.insertRepetition("CSPCSSORCOBROBXORCRXARXR", rep);
    }

    public CSU_C09_CSPCSSORCOBROBXORCRXARXR removeCSPCSSORCOBROBXORCRXARXR(int rep) throws HL7Exception {
        return (CSU_C09_CSPCSSORCOBROBXORCRXARXR)super.removeRepetition("CSPCSSORCOBROBXORCRXARXR", rep);
    }
}

