/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum V3ContainerSeparator {
    GEL,
    NONE,
    NULL;


    public static V3ContainerSeparator fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("GEL".equals(codeString)) {
            return GEL;
        }
        if ("NONE".equals(codeString)) {
            return NONE;
        }
        throw new FHIRException("Unknown V3ContainerSeparator code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case GEL: {
                return "GEL";
            }
            case NONE: {
                return "NONE";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/v3-ContainerSeparator";
    }

    public String getDefinition() {
        switch (this) {
            case GEL: {
                return "A gelatinous type of separator material.";
            }
            case NONE: {
                return "No separator material is present in the container.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case GEL: {
                return "Gel";
            }
            case NONE: {
                return "None";
            }
        }
        return "?";
    }
}

