/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum Udi {
    GUDID,
    NULL;


    public static Udi fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("gudid".equals(codeString)) {
            return GUDID;
        }
        throw new FHIRException("Unknown Udi code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case GUDID: {
                return "gudid";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/ex-udi";
    }

    public String getDefinition() {
        switch (this) {
            case GUDID: {
                return "GUDID (FDA) US Repository";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case GUDID: {
                return "GUDID (FDA)";
            }
        }
        return "?";
    }
}

