/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum TaskCode {
    APPROVE,
    FULFILL,
    ABORT,
    REPLACE,
    CHANGE,
    SUSPEND,
    RESUME,
    NULL;


    public static TaskCode fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("approve".equals(codeString)) {
            return APPROVE;
        }
        if ("fulfill".equals(codeString)) {
            return FULFILL;
        }
        if ("abort".equals(codeString)) {
            return ABORT;
        }
        if ("replace".equals(codeString)) {
            return REPLACE;
        }
        if ("change".equals(codeString)) {
            return CHANGE;
        }
        if ("suspend".equals(codeString)) {
            return SUSPEND;
        }
        if ("resume".equals(codeString)) {
            return RESUME;
        }
        throw new FHIRException("Unknown TaskCode code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case APPROVE: {
                return "approve";
            }
            case FULFILL: {
                return "fulfill";
            }
            case ABORT: {
                return "abort";
            }
            case REPLACE: {
                return "replace";
            }
            case CHANGE: {
                return "change";
            }
            case SUSPEND: {
                return "suspend";
            }
            case RESUME: {
                return "resume";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/CodeSystem/task-code";
    }

    public String getDefinition() {
        switch (this) {
            case APPROVE: {
                return "Take what actions are needed to transition the focus resource from 'draft' to 'active' or 'in-progress', as appropriate for the resource type.  This may involve additing additional content, approval, validation, etc.";
            }
            case FULFILL: {
                return "Act to perform the actions defined in the focus request.  This might result in a 'more assertive' request (order for a plan or proposal, filler order for a placer order), but is intend to eventually result in events.  The degree of fulfillment requested might be limited by Task.restriction.";
            }
            case ABORT: {
                return "Abort, cancel or withdraw the focal resource, as appropriate for the type of resource.";
            }
            case REPLACE: {
                return "Replace the focal resource with the specified input resource";
            }
            case CHANGE: {
                return "Update the focal resource of the owning system to reflect the content specified as the Task.focus";
            }
            case SUSPEND: {
                return "Transition the focal resource from 'active' or 'in-progress' to 'suspended'";
            }
            case RESUME: {
                return "Transition the focal resource from 'suspended' to 'active' or 'in-progress' as appropriate for the resource type.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case APPROVE: {
                return "Activate/approve the focal resource";
            }
            case FULFILL: {
                return "Fulfill the focal request";
            }
            case ABORT: {
                return "Mark the focal resource as no longer active";
            }
            case REPLACE: {
                return "Replace the focal resource with the input resource";
            }
            case CHANGE: {
                return "Change the focal resource";
            }
            case SUSPEND: {
                return "Suspend the focal resource";
            }
            case RESUME: {
                return "Re-activate the focal resource";
            }
        }
        return "?";
    }
}

