/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ResearchStudyStatus {
    ACTIVE,
    ADMINISTRATIVELYCOMPLETED,
    APPROVED,
    CLOSEDTOACCRUAL,
    CLOSEDTOACCRUALANDINTERVENTION,
    COMPLETED,
    DISAPPROVED,
    INREVIEW,
    TEMPORARILYCLOSEDTOACCRUAL,
    TEMPORARILYCLOSEDTOACCRUALANDINTERVENTION,
    WITHDRAWN,
    NULL;


    public static ResearchStudyStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("active".equals(codeString)) {
            return ACTIVE;
        }
        if ("administratively-completed".equals(codeString)) {
            return ADMINISTRATIVELYCOMPLETED;
        }
        if ("approved".equals(codeString)) {
            return APPROVED;
        }
        if ("closed-to-accrual".equals(codeString)) {
            return CLOSEDTOACCRUAL;
        }
        if ("closed-to-accrual-and-intervention".equals(codeString)) {
            return CLOSEDTOACCRUALANDINTERVENTION;
        }
        if ("completed".equals(codeString)) {
            return COMPLETED;
        }
        if ("disapproved".equals(codeString)) {
            return DISAPPROVED;
        }
        if ("in-review".equals(codeString)) {
            return INREVIEW;
        }
        if ("temporarily-closed-to-accrual".equals(codeString)) {
            return TEMPORARILYCLOSEDTOACCRUAL;
        }
        if ("temporarily-closed-to-accrual-and-intervention".equals(codeString)) {
            return TEMPORARILYCLOSEDTOACCRUALANDINTERVENTION;
        }
        if ("withdrawn".equals(codeString)) {
            return WITHDRAWN;
        }
        throw new FHIRException("Unknown ResearchStudyStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case ACTIVE: {
                return "active";
            }
            case ADMINISTRATIVELYCOMPLETED: {
                return "administratively-completed";
            }
            case APPROVED: {
                return "approved";
            }
            case CLOSEDTOACCRUAL: {
                return "closed-to-accrual";
            }
            case CLOSEDTOACCRUALANDINTERVENTION: {
                return "closed-to-accrual-and-intervention";
            }
            case COMPLETED: {
                return "completed";
            }
            case DISAPPROVED: {
                return "disapproved";
            }
            case INREVIEW: {
                return "in-review";
            }
            case TEMPORARILYCLOSEDTOACCRUAL: {
                return "temporarily-closed-to-accrual";
            }
            case TEMPORARILYCLOSEDTOACCRUALANDINTERVENTION: {
                return "temporarily-closed-to-accrual-and-intervention";
            }
            case WITHDRAWN: {
                return "withdrawn";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/research-study-status";
    }

    public String getDefinition() {
        switch (this) {
            case ACTIVE: {
                return "Study is opened for accrual.";
            }
            case ADMINISTRATIVELYCOMPLETED: {
                return "Study is completed prematurely and will not resume; patients are no longer examined nor treated.";
            }
            case APPROVED: {
                return "Protocol is approved by the review board.";
            }
            case CLOSEDTOACCRUAL: {
                return "Study is closed for accrual; patients can be examined and treated.";
            }
            case CLOSEDTOACCRUALANDINTERVENTION: {
                return "Study is closed to accrual and intervention, i.e. the study is closed to enrollment, all study subjects have completed treatment or intervention but are still being followed according to the primary objective of the study.";
            }
            case COMPLETED: {
                return "Study is closed to accrual and intervention, i.e. the study is closed to enrollment, all study subjects have completed treatment\nor intervention but are still being followed according to the primary objective of the study.";
            }
            case DISAPPROVED: {
                return "Protocol was disapproved by the review board.";
            }
            case INREVIEW: {
                return "Protocol is submitted to the review board for approval.";
            }
            case TEMPORARILYCLOSEDTOACCRUAL: {
                return "Study is temporarily closed for accrual; can be potentially resumed in the future; patients can be examined and treated.";
            }
            case TEMPORARILYCLOSEDTOACCRUALANDINTERVENTION: {
                return "Study is temporarily closed for accrual and intervention and potentially can be resumed in the future.";
            }
            case WITHDRAWN: {
                return "Protocol was withdrawn by the lead organization.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case ACTIVE: {
                return "Active";
            }
            case ADMINISTRATIVELYCOMPLETED: {
                return "Administratively Completed";
            }
            case APPROVED: {
                return "Approved";
            }
            case CLOSEDTOACCRUAL: {
                return "Closed to Accrual";
            }
            case CLOSEDTOACCRUALANDINTERVENTION: {
                return "Closed to Accrual and Intervention";
            }
            case COMPLETED: {
                return "Completed";
            }
            case DISAPPROVED: {
                return "Disapproved";
            }
            case INREVIEW: {
                return "In Review";
            }
            case TEMPORARILYCLOSEDTOACCRUAL: {
                return "Temporarily Closed to Accrual";
            }
            case TEMPORARILYCLOSEDTOACCRUALANDINTERVENTION: {
                return "Temporarily Closed to Accrual and Intervention";
            }
            case WITHDRAWN: {
                return "Withdrawn";
            }
        }
        return "?";
    }
}

