/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ProductCategory {
    ORGAN,
    TISSUE,
    FLUID,
    CELLS,
    BIOLOGICALAGENT,
    NULL;


    public static ProductCategory fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("organ".equals(codeString)) {
            return ORGAN;
        }
        if ("tissue".equals(codeString)) {
            return TISSUE;
        }
        if ("fluid".equals(codeString)) {
            return FLUID;
        }
        if ("cells".equals(codeString)) {
            return CELLS;
        }
        if ("biologicalAgent".equals(codeString)) {
            return BIOLOGICALAGENT;
        }
        throw new FHIRException("Unknown ProductCategory code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case ORGAN: {
                return "organ";
            }
            case TISSUE: {
                return "tissue";
            }
            case FLUID: {
                return "fluid";
            }
            case CELLS: {
                return "cells";
            }
            case BIOLOGICALAGENT: {
                return "biologicalAgent";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/product-category";
    }

    public String getDefinition() {
        switch (this) {
            case ORGAN: {
                return "A collection of tissues joined in a structural unit to serve a common function.";
            }
            case TISSUE: {
                return "An ensemble of similar cells and their extracellular matrix from the same origin that together carry out a specific function.";
            }
            case FLUID: {
                return "Body fluid.";
            }
            case CELLS: {
                return "Collection of cells.";
            }
            case BIOLOGICALAGENT: {
                return "Biological agent of unspecified type.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case ORGAN: {
                return "Organ";
            }
            case TISSUE: {
                return "Tissue";
            }
            case FLUID: {
                return "Fluid";
            }
            case CELLS: {
                return "Cells";
            }
            case BIOLOGICALAGENT: {
                return "BiologicalAgent";
            }
        }
        return "?";
    }
}

