/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.codesystems.PermittedDataType;

public class PermittedDataTypeEnumFactory
implements EnumFactory<PermittedDataType> {
    @Override
    public PermittedDataType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("Quantity".equals(codeString)) {
            return PermittedDataType.QUANTITY;
        }
        if ("CodeableConcept".equals(codeString)) {
            return PermittedDataType.CODEABLECONCEPT;
        }
        if ("string".equals(codeString)) {
            return PermittedDataType.STRING;
        }
        if ("boolean".equals(codeString)) {
            return PermittedDataType.BOOLEAN;
        }
        if ("integer".equals(codeString)) {
            return PermittedDataType.INTEGER;
        }
        if ("Range".equals(codeString)) {
            return PermittedDataType.RANGE;
        }
        if ("Ratio".equals(codeString)) {
            return PermittedDataType.RATIO;
        }
        if ("SampledData".equals(codeString)) {
            return PermittedDataType.SAMPLEDDATA;
        }
        if ("time".equals(codeString)) {
            return PermittedDataType.TIME;
        }
        if ("dateTime".equals(codeString)) {
            return PermittedDataType.DATETIME;
        }
        if ("Period".equals(codeString)) {
            return PermittedDataType.PERIOD;
        }
        throw new IllegalArgumentException("Unknown PermittedDataType code '" + codeString + "'");
    }

    @Override
    public String toCode(PermittedDataType code) {
        if (code == PermittedDataType.QUANTITY) {
            return "Quantity";
        }
        if (code == PermittedDataType.CODEABLECONCEPT) {
            return "CodeableConcept";
        }
        if (code == PermittedDataType.STRING) {
            return "string";
        }
        if (code == PermittedDataType.BOOLEAN) {
            return "boolean";
        }
        if (code == PermittedDataType.INTEGER) {
            return "integer";
        }
        if (code == PermittedDataType.RANGE) {
            return "Range";
        }
        if (code == PermittedDataType.RATIO) {
            return "Ratio";
        }
        if (code == PermittedDataType.SAMPLEDDATA) {
            return "SampledData";
        }
        if (code == PermittedDataType.TIME) {
            return "time";
        }
        if (code == PermittedDataType.DATETIME) {
            return "dateTime";
        }
        if (code == PermittedDataType.PERIOD) {
            return "Period";
        }
        return "?";
    }

    @Override
    public String toSystem(PermittedDataType code) {
        return code.getSystem();
    }
}

